/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.watermark;

import com.day.cq.dam.commons.watermark.Location;

public abstract class Watermark {
    public static final Location DEFAULT_LOCATION = Location.CENTER;
    public static final double DEFAULT_ORIENTATION = 0.0;
    public static final float DEFAULT_OPACITY = 0.2f;
    private Location position = DEFAULT_LOCATION;
    private int top = -1;
    private int left = -1;
    private double orientation = 0.0;
    private float opacity = 0.2f;

    protected Watermark() {
    }

    protected Watermark(Location position, double orientation, float opacity) {
        this.position = position;
        this.opacity = opacity;
        this.orientation = orientation;
    }

    protected Watermark(int top, int left, double orientation, float opacity) {
        this.top = top;
        this.left = left;
        this.orientation = orientation;
        this.opacity = opacity;
    }

    protected Watermark(Location position) {
        this.position = position;
    }

    protected Watermark(int top, int left) {
        this.top = top;
        this.left = left;
    }

    public Location getPosition() {
        return this.position;
    }

    public void setPosition(Location position) {
        this.position = position;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public void setCoords(int imgWidth, int imgHeight, int wmWidth, int wmHeight) {
        switch (this.position) {
            case TOP_LEFT: {
                this.top = 0;
                this.left = 0;
                break;
            }
            case BOTTOM_LEFT: {
                this.top = imgHeight - wmHeight;
                this.left = 0;
                break;
            }
            case TOP_RIGHT: {
                this.top = 0;
                this.left = imgWidth - wmWidth;
                break;
            }
            case BOTTOM_RIGHT: {
                this.top = imgHeight - wmHeight;
                this.left = imgWidth - wmWidth;
                break;
            }
            case CENTER: {
                this.top = (imgHeight - wmHeight) / 2;
                this.left = (imgWidth - wmWidth) / 2;
            }
        }
    }

    public String toString() {
        return "\ntop = " + this.top + "\nleft = " + this.left + "\norientation = " + this.orientation + "\nopacity = " + this.opacity + "\nposition = " + this.position.name();
    }
}

