/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import java.util.Collections;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMediaHelper {
    private static final String DYNAMIC_MEDIA_CONFIG_PATH = "/etc/dam/dynamicmediaconfig";
    private static final String PN_DYNAMIC_MEDIA_ENABLED = "dynamicMediaEnabled";
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMediaHelper.class);

    public static boolean isDynamicMediaEnabled(ResourceResolver resolver) {
        ValueMap configProperties = DynamicMediaHelper.getDynamicMediaConfigurationProperties(resolver);
        return configProperties.get(PN_DYNAMIC_MEDIA_ENABLED, false);
    }

    private static ValueMap getDynamicMediaConfigurationProperties(ResourceResolver resolver) {
        ValueMap configProps = null;
        try {
            Resource dmConfigResource = resolver.getResource(DYNAMIC_MEDIA_CONFIG_PATH);
            configProps = dmConfigResource.adaptTo(ValueMap.class);
        }
        catch (Exception e) {
            LOG.error("Could not read the Dynamic Media configuration from node /etc/dam/dynamicmediaconfig", (Throwable)e);
        }
        if (configProps == null) {
            configProps = new ValueMapDecorator(Collections.<String, Object>emptyMap());
        }
        return configProps;
    }
}

