/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.thumbnail;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPIterator;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.options.IteratorOptions;
import com.adobe.xmp.properties.XMPProperty;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.day.cq.dam.api.Context;
import com.day.cq.dam.api.Processor;
import com.day.cq.dam.api.ProcessorException;
import com.day.cq.dam.commons.handler.Filter;
import com.day.cq.dam.commons.handler.FilterStateListener;
import com.day.cq.dam.commons.handler.XPacketFilter;
import com.day.image.Layer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;

public class XapThumbnailsProcessor
implements Processor,
FilterStateListener {
    private static final String XMP_SCHEMA_NS = "http://ns.adobe.com/xap/1.0/";
    private static final String PN_THUMBNAILS = "Thumbnails";
    private static final String XMPIMG_SCHEMA_NS = "http://ns.adobe.com/xap/1.0/g/img/";
    private static final String PN_IMAGE = "image";
    private Context context;
    private XPacketFilter xmpFilter;

    public XapThumbnailsProcessor(Context context) {
        this.context = context;
        this.xmpFilter = new XPacketFilter();
        this.xmpFilter.setFilterStateListener(this);
        this.xmpFilter.setAutoReset(true);
    }

    public final void process(byte[] buf, int off, int len) throws IOException {
        this.xmpFilter.filter(buf, off, len);
    }

    public OutputStream started(Filter filter) {
        return new ByteArrayOutputStream(8192);
    }

    public void ended(Filter filter, OutputStream out) {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)out;
        byte[] data = bos.toByteArray();
        XMPMeta xmp = null;
        try {
            xmp = XMPMetaFactory.parseFromBuffer(data);
        }
        catch (XMPException e) {
            String msg = "Unable to get XMP object from input";
            this.context.addException(new ProcessorException(msg, e, this));
            return;
        }
        try {
            XMPIterator iter = xmp.iterator(XMP_SCHEMA_NS, PN_THUMBNAILS, new IteratorOptions().setJustChildren(true));
            while (iter.hasNext()) {
                XMPPropertyInfo thumbnail = (XMPPropertyInfo)iter.next();
                XMPProperty image = xmp.getStructField(XMP_SCHEMA_NS, thumbnail.getPath(), XMPIMG_SCHEMA_NS, PN_IMAGE);
                if (image == null) continue;
                byte[] encoded = ((String)image.getValue()).getBytes();
                byte[] decoded = Base64.decodeBase64((byte[])encoded);
                this.context.addThumbnail(new Layer(new ByteArrayInputStream(decoded)).getImage());
            }
        }
        catch (XMPException e) {
            String msg = "Unable to locate image inside thumbnail";
            this.context.addException(new ProcessorException(msg, e, this));
        }
        catch (IOException e) {
            String msg = "Unable to get buffered image from JPEG";
            this.context.addException(new ProcessorException(msg, e, this));
        }
    }
}

