/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import com.day.cq.commons.servlets.AbstractListServlet;
import com.day.cq.replication.ReplicationStatus;
import java.text.Collator;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.SlingHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, componentAbstract=true)
public class AbstractReplicableListServlet
extends AbstractListServlet {
    public static final String SORT_REPLICATION = "replication";

    @Override
    protected List<AbstractListServlet.ListItem> applySorting(SlingHttpServletRequest request, List<AbstractListServlet.ListItem> items) {
        String sortKey = request.getParameter("sort") != null ? request.getParameter("sort") : "index";
        String sortDir = request.getParameter("dir") != null ? request.getParameter("dir") : "ASC";
        this.getCollator().setStrength(0);
        if (!"index".equals(sortKey) || !"ASC".equals(sortDir)) {
            Collections.sort(items, new ListItemComparator(sortKey));
            if ("DESC".equals(sortDir)) {
                Collections.reverse(items);
            }
        }
        return items;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListItemComparator
    implements Comparator<AbstractListServlet.ListItem> {
        private String compareField;

        public ListItemComparator(String compareField) {
            this.compareField = compareField;
        }

        @Override
        public int compare(AbstractListServlet.ListItem li1, AbstractListServlet.ListItem li2) {
            try {
                Object v2;
                Object v1;
                ListItem o1 = (ListItem)li1;
                ListItem o2 = (ListItem)li2;
                if (AbstractReplicableListServlet.SORT_REPLICATION.equals(this.compareField)) {
                    Calendar c1 = o1.getReplicationStatus().getLastPublished();
                    Calendar c2 = o2.getReplicationStatus().getLastPublished();
                    v1 = c1 == null ? 0L : c1.getTimeInMillis();
                    v2 = c2 == null ? 0L : c2.getTimeInMillis();
                } else {
                    v1 = o1.getClass().getField(this.compareField).get(o1);
                    v2 = o2.getClass().getField(this.compareField).get(o2);
                }
                if (v1 instanceof String && v2 instanceof String) {
                    Collator collator = AbstractReplicableListServlet.this.getCollator();
                    return collator != null ? collator.compare((String)v1, (String)v2) : ((String)v1).compareTo((String)v2);
                }
                if (v1 instanceof Integer && v2 instanceof Integer) {
                    int int2;
                    int int1 = (Integer)v1;
                    return int1 > (int2 = ((Integer)v2).intValue()) ? 1 : (int1 != int2 ? -1 : 0);
                }
                if (v1 instanceof Long && v2 instanceof Long) {
                    long long2;
                    long long1 = (Long)v1;
                    return long1 > (long2 = ((Long)v2).longValue()) ? 1 : (long1 != long2 ? -1 : 0);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            return 0;
        }
    }

    public static interface ListItem
    extends AbstractListServlet.ListItem {
        public ReplicationStatus getReplicationStatus();
    }
}

