/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import com.day.cq.commons.ListInfoProvider;
import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.commons.servlets.AbstractPredicateServlet;
import java.io.IOException;
import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, componentAbstract=true)
public class AbstractListServlet
extends AbstractPredicateServlet {
    private static final Logger log = LoggerFactory.getLogger(AbstractListServlet.class);
    private Collator collator = Collator.getInstance();
    protected static final long serialVersionUID = 2138470595710406273L;
    public static final String TIDY = "tidy";
    public static final String PAGE_START = "start";
    public static final String PAGE_LIMIT = "limit";
    public static final String SORT_KEY = "sort";
    public static final String SORT_DIR = "dir";
    public static final String SORT_ASCENDING = "ASC";
    public static final String SORT_DESCENDING = "DESC";
    public static final String PATH = "path";
    public static final String PAGE_INDEX = "index";
    public static final String PROP = "prop";
    protected static final String DEFAULT_TIDY = "true";
    protected static final String DEFAULT_SORT_KEY = "index";
    protected static final String DEFAULT_SORT_DIR = "ASC";
    protected static final String CONTENT_TYPE = "application/json";
    protected static final String ENCODING = "utf-8";
    @Reference(policy=ReferencePolicy.STATIC)
    protected SlingRepository repository;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected ListInfoProvider listInfoProvider;
    protected Session admin;
    private final List<ServiceReference> delayedProviders = new ArrayList<ServiceReference>();
    private final List<ServiceReference> providers = new ArrayList<ServiceReference>();
    private List<ListInfoProvider> cachedProviders = Collections.emptyList();
    private ComponentContext componentContext;

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response, Predicate predicate) throws ServletException, IOException {
        try {
            List<ListItem> items = this.getItems(request, predicate);
            int total = items.size();
            if (request.getParameter("index") != null) {
                String path = request.getParameter(PATH);
                this.writePagingIndex(request, response, items, path);
                return;
            }
            items = this.processItems(request, items, total);
            String[] customProps = request.getParameterValues(PROP);
            this.write(request, response, items, customProps, total);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected List<ListItem> getItems(SlingHttpServletRequest request, Predicate predicate) throws Exception {
        return null;
    }

    protected List<ListItem> processItems(SlingHttpServletRequest request, List<ListItem> items, int total) {
        return this.applyPaging(request, this.applySorting(request, items), total);
    }

    protected List<ListItem> applySorting(SlingHttpServletRequest request, List<ListItem> items) {
        String sortKey = request.getParameter(SORT_KEY) != null ? request.getParameter(SORT_KEY) : "index";
        String sortDir = request.getParameter(SORT_DIR) != null ? request.getParameter(SORT_DIR) : "ASC";
        this.collator.setStrength(0);
        if (!"index".equals(sortKey) || !"ASC".equals(sortDir)) {
            Collections.sort(items, new ListItemComparator(sortKey));
            if (SORT_DESCENDING.equals(sortDir)) {
                Collections.reverse(items);
            }
        }
        return items;
    }

    protected List<ListItem> applyPaging(SlingHttpServletRequest request, List<ListItem> items, int total) {
        int start = 0;
        int end = Integer.MAX_VALUE;
        if (request.getParameter(PAGE_START) != null) {
            try {
                start = Integer.parseInt(request.getParameter(PAGE_START));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (request.getParameter(PAGE_LIMIT) != null) {
            try {
                end = Integer.parseInt(request.getParameter(PAGE_LIMIT)) + start;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (start > 0 || total > end - start) {
            if (start > total - 1) {
                start = total;
            }
            if (end > total - 1) {
                end = total;
            }
            items = items.subList(start, end);
        }
        return items;
    }

    protected long getPagingIndex(SlingHttpServletRequest request, List<ListItem> items, String path) {
        if (path == null) {
            return -1L;
        }
        int limit = Integer.MAX_VALUE;
        if (request.getParameter(PAGE_LIMIT) != null) {
            try {
                limit = Integer.parseInt(request.getParameter(PAGE_LIMIT));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        Iterator<ListItem> iterator = items.iterator();
        long index = 0L;
        int counter = 0;
        boolean found = false;
        while (iterator.hasNext()) {
            if (path.equals(iterator.next().getResource().getPath())) {
                found = true;
                break;
            }
            if (++counter != limit) continue;
            ++index;
            counter = 0;
        }
        return found ? index : -1L;
    }

    protected void write(SlingHttpServletRequest request, SlingHttpServletResponse response, List<ListItem> listItems, String[] customProps, int total) throws Exception {
        response.setContentType(CONTENT_TYPE);
        response.setCharacterEncoding(ENCODING);
        JSONObject json = new JSONObject();
        List<ListInfoProvider> listInfoProviders = this.cachedProviders;
        JSONArray listArray = new JSONArray();
        for (ListItem item : listItems) {
            StringWriter out = new StringWriter();
            TidyJSONWriter writer = new TidyJSONWriter(out);
            ((JSONWriter)writer).setTidy(DEFAULT_TIDY.equals(request.getParameter(TIDY)));
            item.write(writer, customProps);
            JSONObject info = new JSONObject(out.toString());
            Resource resource = item.getResource();
            for (ListInfoProvider p : listInfoProviders) {
                long t0 = System.currentTimeMillis();
                p.updateListItemInfo(request, info, resource);
                long t1 = System.currentTimeMillis();
                log.debug("{}.updateListItemInfo() in {}ms", (Object)p.getClass().getName(), (Object)(t1 - t0));
            }
            listArray.put(info);
        }
        json.put("pages", listArray);
        json.put("results", total);
        Resource resource = request.getResource();
        for (ListInfoProvider p : listInfoProviders) {
            long t0 = System.currentTimeMillis();
            p.updateListGlobalInfo(request, json, resource);
            long t1 = System.currentTimeMillis();
            log.debug("{}.updateListGlobalInfo() in {}ms", (Object)p.getClass().getName(), (Object)(t1 - t0));
        }
        json.write(response.getWriter());
    }

    protected void writeKey(JSONWriter out, String key, Object value) throws JSONException {
        out.key(key).value(value);
    }

    protected void writeOptionalKey(JSONWriter out, String key, Object value) throws JSONException {
        if (value != null) {
            this.writeKey(out, key, value);
        }
    }

    protected void writeOptionalDateKey(JSONWriter out, String key, Calendar value) throws JSONException {
        if (value != null) {
            out.key(key).value(value.getTimeInMillis());
        }
    }

    protected void writeCustomProperties(JSONWriter out, Resource resource, String[] customProps) throws JSONException {
        ValueMap props;
        if (customProps != null && (props = resource.adaptTo(ValueMap.class)) != null) {
            for (String name : customProps) {
                this.writeOptionalKey(out, name, props.get(name, null));
            }
        }
    }

    protected void writePagingIndex(SlingHttpServletRequest request, SlingHttpServletResponse response, List<ListItem> listItems, String path) throws Exception {
        response.setContentType(CONTENT_TYPE);
        response.setCharacterEncoding(ENCODING);
        JSONWriter writer = new JSONWriter(response.getWriter());
        writer.setTidy(DEFAULT_TIDY.equals(request.getParameter(TIDY)));
        writer.object();
        writer.key("index").value(this.getPagingIndex(request, this.applySorting(request, listItems), path));
        writer.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws Exception {
        this.admin = this.repository.loginAdministrative(null);
        List<ServiceReference> list = this.delayedProviders;
        synchronized (list) {
            this.componentContext = context;
            for (ServiceReference ref : this.delayedProviders) {
                this.registerProvider(ref);
            }
            this.delayedProviders.clear();
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.admin != null && this.admin.isLive()) {
            this.admin.logout();
            this.admin = null;
        }
        this.componentContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindListInfoProvider(ServiceReference ref) {
        List<ServiceReference> list = this.delayedProviders;
        synchronized (list) {
            if (this.componentContext == null) {
                this.delayedProviders.add(ref);
            } else {
                this.registerProvider(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindListInfoProvider(ServiceReference ref) {
        List<ServiceReference> list = this.delayedProviders;
        synchronized (list) {
            this.delayedProviders.remove(ref);
            this.providers.remove(ref);
        }
    }

    protected void registerProvider(ServiceReference ref) {
        this.providers.add(ref);
        ArrayList<ListInfoProvider> pvs = new ArrayList<ListInfoProvider>();
        for (ServiceReference current : this.providers) {
            ListInfoProvider provider = (ListInfoProvider)this.componentContext.locateService("listInfoProvider", current);
            if (provider == null) continue;
            pvs.add(provider);
        }
        this.cachedProviders = pvs;
    }

    protected Collator getCollator() {
        return this.collator;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListItemComparator
    implements Comparator<ListItem> {
        private String compareField;

        public ListItemComparator(String compareField) {
            this.compareField = compareField;
        }

        @Override
        public int compare(ListItem o1, ListItem o2) {
            try {
                Object v1 = o1.getClass().getField(this.compareField).get(o1);
                Object v2 = o2.getClass().getField(this.compareField).get(o2);
                if (v1 instanceof String && v2 instanceof String) {
                    return AbstractListServlet.this.collator != null ? AbstractListServlet.this.collator.compare((String)v1, (String)v2) : ((String)v1).compareTo((String)v2);
                }
                if (v1 instanceof Integer && v2 instanceof Integer) {
                    int int2;
                    int int1 = (Integer)v1;
                    return int1 > (int2 = ((Integer)v2).intValue()) ? 1 : (int1 != int2 ? -1 : 0);
                }
                if (v1 instanceof Long && v2 instanceof Long) {
                    long long2;
                    long long1 = (Long)v1;
                    return long1 > (long2 = ((Long)v2).longValue()) ? 1 : (long1 != long2 ? -1 : 0);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            return 0;
        }
    }

    public static interface ListItem {
        public static final String INDEX = "index";
        public static final String PATH = "path";
        public static final String LABEL = "label";
        public static final String TYPE = "type";
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String LAST_MODIFIED = "lastModified";
        public static final String LAST_MODIFIED_BY = "lastModifiedBy";
        public static final String LOCKED_BY = "lockedBy";
        public static final String MONTHLY_HITS = "monthlyHits";
        public static final String REPLICATION = "replication";
        public static final String REPLICATION_NUM_QUEUED = "numQueued";
        public static final String REPLICATION_ACTION = "action";
        public static final String REPLICATION_PUBLISHED = "published";
        public static final String REPLICATION_PUBLISHED_BY = "publishedBy";
        public static final String IN_WORKFLOW = "inWorkflow";
        public static final String WORKFLOWS = "workflows";
        public static final String WORKFLOW_MODEL = "model";
        public static final String WORKFLOW_STARTED = "started";
        public static final String WORKFLOW_STARTED_BY = "startedBy";
        public static final String WORKFLOW_SUSPENDED = "suspended";
        public static final String WORKFLOW_WORK_ITEMS = "workItems";
        public static final String WORKFLOW_WORK_ITEM_TITLE = "item";
        public static final String WORKFLOW_WORK_ITEM_ASSIGNEE = "assignee";
        public static final String SCHEDULED_TASKS = "scheduledTasks";
        public static final String SCHEDULED_TASK_VERSION = "version";
        public static final String SCHEDULED_TASK_SCHEDULED = "scheduled";
        public static final String SCHEDULED_TASK_SCHEDULED_BY = "scheduledBy";
        public static final String SCHEDULED_TASK_TYPE = "type";
        public static final String SCHEDULED_ACTIVATION_WORKFLOW_ID = "/etc/workflow/models/scheduled_activation/jcr:content/model";
        public static final String SCHEDULED_DEACTIVATION_WORKFLOW_ID = "/etc/workflow/models/scheduled_deactivation/jcr:content/model";

        public void write(JSONWriter var1, String[] var2) throws Exception;

        public Resource getResource();
    }
}

