/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.date;

import com.day.cq.i18n.I18n;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Period;

public class RelativeTimeFormat {
    private static final String PATTERN_CHARS = "dDhmMrsyY";
    public static final String SHORT = "r";
    public static final String FULL = "y M d h m s";
    public static final String FACEBOOK = "r";
    public static final String GMAIL = "Y";
    private final ResourceBundle bundle;
    private final char[] compiledPattern;
    private final Calendar calendar;
    private final Calendar now;
    private final SimpleDateFormat timeFmt;
    private final SimpleDateFormat shortFmt;
    private final SimpleDateFormat longFmt;
    private Locale locale;
    private Period period;
    private I18n i18n;

    public RelativeTimeFormat(String pattern) {
        this(pattern, null, null, null, null);
    }

    public RelativeTimeFormat(String pattern, ResourceBundle bundle) {
        this(pattern, null, null, null, bundle);
    }

    public RelativeTimeFormat(String pattern, String timePattern, String shortPattern, String longPattern, ResourceBundle bundle) {
        if (StringUtils.isBlank((String)pattern)) {
            throw new IllegalArgumentException("pattern may not be null or empty");
        }
        this.bundle = bundle;
        this.getLocale();
        this.i18n = new I18n(bundle);
        this.compiledPattern = this.compile(pattern);
        this.calendar = Calendar.getInstance(this.locale);
        this.now = Calendar.getInstance(this.locale);
        this.timeFmt = new SimpleDateFormat(StringUtils.defaultIfEmpty((String)timePattern, (String)this.i18n.get("HH:mm", "Java date format for a time (http://java.sun.com/j2se/1.5.0/docs/api/java/text/SimpleDateFormat.html)")), this.locale);
        this.shortFmt = new SimpleDateFormat(StringUtils.defaultIfEmpty((String)shortPattern, (String)this.i18n.get("MMM d", "Java date format for a date (http://java.sun.com/j2se/1.5.0/docs/api/java/text/SimpleDateFormat.html)")), this.locale);
        this.longFmt = new SimpleDateFormat(StringUtils.defaultIfEmpty((String)longPattern, (String)this.i18n.get("MM/dd/yyyy", "Java date format for a date (http://java.sun.com/j2se/1.5.0/docs/api/java/text/SimpleDateFormat.html)")), this.locale);
    }

    public String format(long start) {
        return this.format(start, System.currentTimeMillis(), false);
    }

    public String format(long start, boolean ago) {
        return this.format(start, System.currentTimeMillis(), ago);
    }

    public String format(long start, long end) {
        return this.format(start, end, false);
    }

    public String format(long start, long end, boolean ago) {
        this.calendar.setTimeInMillis(start);
        this.now.setTimeInMillis(end);
        this.period = new Period(start, end);
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        for (char c : this.compiledPattern) {
            int index = PATTERN_CHARS.indexOf(c);
            if (index >= 0) {
                if (i == this.compiledPattern.length - 1) {
                    this.fieldFormat(index, buffer, ago);
                } else {
                    this.fieldFormat(index, buffer, false);
                }
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private void fieldFormat(int index, StringBuilder buffer, boolean ago) {
        int years = this.period.getYears();
        int months = this.period.getMonths();
        int weeks = this.period.getWeeks();
        int days = weeks > 0 ? this.period.getDays() + weeks * 7 : this.period.getDays();
        int hours = this.period.getHours();
        int minutes = this.period.getMinutes();
        int seconds = this.period.getSeconds();
        String result = "";
        switch (index) {
            case 0: {
                if (days == 1) {
                    result = ago ? this.i18n.get("{0} day ago", null, days) : this.i18n.get("{0} day", null, days);
                    break;
                }
                result = ago ? this.i18n.get("{0} days ago", null, days) : this.i18n.get("{0} days", null, days);
                break;
            }
            case 1: {
                buffer.append(this.getDynamicDate(months, weeks, days));
                break;
            }
            case 2: {
                if (hours == 1) {
                    result = ago ? this.i18n.get("{0} hour ago", null, hours) : this.i18n.get("{0} hour", null, hours);
                    break;
                }
                result = ago ? this.i18n.get("{0} hours ago", null, hours) : this.i18n.get("{0} hours", null, hours);
                break;
            }
            case 3: {
                if (minutes == 1) {
                    result = ago ? this.i18n.get("{0} minute ago", null, minutes) : this.i18n.get("{0} minute", null, minutes);
                    break;
                }
                result = ago ? this.i18n.get("{0} minutes ago", null, minutes) : this.i18n.get("{0} minutes", null, minutes);
                break;
            }
            case 4: {
                if (months == 1) {
                    result = ago ? this.i18n.get("{0} month ago", null, months) : this.i18n.get("{0} month", null, months);
                    break;
                }
                result = ago ? this.i18n.get("{0} months ago", null, months) : this.i18n.get("{0} months", null, months);
                break;
            }
            case 5: {
                buffer.append(this.getRelative(years, months, days, hours, minutes, seconds, ago));
                break;
            }
            case 6: {
                if (seconds < 1) {
                    result = this.i18n.get("now", null, seconds);
                    break;
                }
                if (seconds == 1) {
                    result = ago ? this.i18n.get("{0} second ago", null, seconds) : this.i18n.get("{0} second", null, seconds);
                    break;
                }
                result = ago ? this.i18n.get("{0} seconds ago", null, seconds) : this.i18n.get("{0} seconds", null, seconds);
                break;
            }
            case 7: {
                if (years == 1) {
                    result = ago ? this.i18n.get("{0} year ago", null, years) : this.i18n.get("{0} year", null, years);
                    break;
                }
                result = ago ? this.i18n.get("{0} years ago", null, years) : this.i18n.get("{0} years", null, years);
                break;
            }
            case 8: {
                buffer.append(this.getDynamicDate(months, weeks, days));
                if (this.calendar.get(1) != this.now.get(1) || months != 0 || weeks >= 2) break;
                buffer.append(" (").append(this.i18n.get("{0}", null, this.getRelative(years, months, days, hours, minutes, seconds, true))).append(")");
                break;
            }
        }
        buffer.append(result);
    }

    private String getRelative(int years, int months, int days, int hours, int minutes, int seconds, boolean ago) {
        String label = "";
        if (0 < years) {
            label = years == 1 ? (ago ? this.i18n.get("{0} year ago", null, years) : this.i18n.get("{0} year", null, years)) : (ago ? this.i18n.get("{0} years ago", null, years) : this.i18n.get("{0} years", null, years));
        } else if (0 < months) {
            label = months == 1 ? (ago ? this.i18n.get("{0} month ago", null, months) : this.i18n.get("{0} month", null, months)) : (ago ? this.i18n.get("{0} months ago", null, months) : this.i18n.get("{0} months", null, months));
        } else if (0 < days) {
            int count = days;
            label = count == 1 ? (ago ? this.i18n.get("{0} day ago", null, count) : this.i18n.get("{0} day", null, count)) : (ago ? this.i18n.get("{0} days ago", null, count) : this.i18n.get("{0} days", null, count));
        } else if (0 < hours) {
            label = hours == 1 ? (ago ? this.i18n.get("{0} hour ago", null, hours) : this.i18n.get("{0} hour", null, hours)) : (ago ? this.i18n.get("{0} hours ago", null, hours) : this.i18n.get("{0} hours", null, hours));
        } else if (0 < minutes) {
            label = minutes == 1 ? (ago ? this.i18n.get("{0} minute ago", null, minutes) : this.i18n.get("{0} minute", null, minutes)) : (ago ? this.i18n.get("{0} minutes ago", null, minutes) : this.i18n.get("{0} minutes", null, minutes));
        } else if (0 <= seconds) {
            label = seconds < 1 ? this.i18n.get("now", null, seconds) : (seconds == 1 ? (ago ? this.i18n.get("{0} second ago", null, seconds) : this.i18n.get("{0} second", null, seconds)) : (ago ? this.i18n.get("{0} seconds ago", null, seconds) : this.i18n.get("{0} seconds", null, seconds)));
        }
        return label;
    }

    private String getDynamicDate(int months, int weeks, int days) {
        if (this.calendar.get(1) < this.now.get(1)) {
            return this.longFmt.format(this.calendar.getTime());
        }
        if (months > 0 || weeks >= 2) {
            return this.shortFmt.format(this.calendar.getTime());
        }
        if (days > 0) {
            return this.shortFmt.format(this.calendar.getTime());
        }
        return this.timeFmt.format(this.calendar.getTime());
    }

    private char[] compile(String pattern) {
        StringBuilder buffer = new StringBuilder();
        int length = pattern.length();
        for (int i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                buffer.append(c);
                continue;
            }
            if (PATTERN_CHARS.indexOf(c) >= 0) {
                buffer.append(c);
                continue;
            }
            throw new IllegalArgumentException("illegal pattern character \"'" + c + "'");
        }
        return buffer.toString().toCharArray();
    }

    private Locale getLocale() {
        if (null == this.locale && null != this.bundle) {
            this.locale = this.bundle.getLocale();
        } else if (null != this.locale) {
            return this.locale;
        }
        if (null == this.locale) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }
}

