/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.day.cq.commons.Item;
import com.day.cq.xss.XSSProtectionService;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONWriterUtil {
    private static final Logger log = LoggerFactory.getLogger(JSONWriterUtil.class);
    public static final String KEY_SUFFIX_XSS = "_xss";

    public static void put(JSONObject object, String key, String value, WriteMode writeMode, XSSProtectionService xss) throws JSONException {
        Item item = new Item(key, value, writeMode, xss, log);
        if (item.isPlainText()) {
            object.put(item.getKey(), item.getValue());
        }
        if (item.isAvoidXSS() && null != xss) {
            object.put(item.getXssKey(), item.getXssValue());
        }
    }

    public static void putOptional(JSONObject object, String key, String value, WriteMode writeMode, XSSProtectionService xss) throws JSONException {
        if (value != null) {
            JSONWriterUtil.put(object, key, value, writeMode, xss);
        }
    }

    public static void write(JSONWriter writer, String key, String value, WriteMode writeMode, XSSProtectionService xss) throws JSONException {
        Item item = new Item(key, value, writeMode, xss, log);
        if (item.isPlainText()) {
            writer.key(item.getKey()).value(item.getValue());
        }
        if (item.isAvoidXSS() && null != xss) {
            writer.key(item.getXssKey()).value(item.getXssValue());
        }
    }

    public static void writeOptional(JSONWriter writer, String key, String value, WriteMode writeMode, XSSProtectionService xss) throws JSONException {
        if (value != null) {
            JSONWriterUtil.write(writer, key, value, writeMode, xss);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WriteMode {
        PLAIN_TEXT,
        AVOID_XSS,
        BOTH;

    }
}

