/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget.util;

import com.day.cq.analytics.AnalyticsException;
import com.day.cq.analytics.testandtarget.util.MboxHelper;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class OfferHelper {
    private static final String DISPLAY_MBOX = "* display mbox *";
    public static final String PN_THIRDPARTYID = "ttThirdPartyId";
    public static final String RT_CAMPAIGN = "cq/personalization/components/campaignpage";
    public static final String RT_EXPERIENCE = "cq/personalization/components/experiencepage";
    public static final String RT_TEASER = "cq/personalization/components/teaserpage";
    public static final String PN_TESTANDTARGETCONFIG = "testandtargetconfig";
    public static final String PN_LOCATION = "location";

    public static String getOfferName(String path) {
        return path.substring(1).replace("/", "-");
    }

    public static String getCampaignName(String path) {
        return OfferHelper.getOfferName(path);
    }

    public static synchronized void setThirdPartyID(Node node, String operation, String thirdpartyid) throws RepositoryException {
        if ("saveWidgetOffer".equals(operation)) {
            node.setProperty(PN_THIRDPARTYID, thirdpartyid);
        } else if ("deleteWidgetOffer".equals(operation) && node.hasProperty(PN_THIRDPARTYID)) {
            node.getProperty(PN_THIRDPARTYID).remove();
        }
    }

    public static String getThirdPartyID(Node node) throws RepositoryException {
        String thirdPartyID = null;
        thirdPartyID = node.hasProperty(PN_THIRDPARTYID) ? node.getProperty(PN_THIRDPARTYID).getString() : Long.toString(System.currentTimeMillis());
        return thirdPartyID;
    }

    public static String getThirdPartyCampaignId(Node contentResourceNode) throws RepositoryException {
        if (contentResourceNode.hasProperty(PN_THIRDPARTYID)) {
            return contentResourceNode.getProperty(PN_THIRDPARTYID).getString();
        }
        return OfferHelper.getCampaignName(contentResourceNode.getParent().getPath());
    }

    public static synchronized void setConfigurationPath(String path, Page page) throws AnalyticsException, RepositoryException {
        Page campaignPage = OfferHelper.getCampaign(page);
        if (campaignPage != null) {
            Node campaignContent = campaignPage.getContentResource().adaptTo(Node.class);
            campaignContent.setProperty(PN_TESTANDTARGETCONFIG, path);
        }
    }

    public static Page getCampaign(Page page) {
        Page campaignPage;
        for (campaignPage = page; campaignPage != null && !RT_CAMPAIGN.equals(campaignPage.getContentResource().getResourceType()); campaignPage = campaignPage.getParent()) {
        }
        return campaignPage;
    }

    public static String getOfferLocation(Page offerPage, WCMMode wcmMode) {
        String location = offerPage.getProperties().get(PN_LOCATION, "");
        if ("".equals(location)) {
            return DISPLAY_MBOX;
        }
        return MboxHelper.qualifyMboxNameOrId(MboxHelper.getMboxId(location), wcmMode);
    }
}

