/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.core.serializer;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeOptions
implements Cloneable {
    private EnumSet<Option> options = EnumSet.of(Option.CANONICAL_FORMAT);
    private int padding = 2048;
    private String newline = "\n";
    private String indent = "  ";
    private int baseIndent = 0;

    public SerializeOptions(Option ... options) {
        this.options.remove((Object)Option.CANONICAL_FORMAT);
        for (Option option : options) {
            this.options.add(option);
        }
    }

    public boolean hasOption(Option option) {
        return this.options.contains((Object)option);
    }

    public void add(Option option) {
        this.options.add(option);
    }

    public void remove(Option option) {
        this.options.remove((Object)option);
    }

    public EnumSet<Option> getOptions() {
        return this.options;
    }

    public void setOptions(EnumSet<Option> options) {
        this.options = options;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public int getBaseIndent() {
        return this.baseIndent;
    }

    public void setBaseIndent(int baseIndent) {
        this.baseIndent = baseIndent;
    }

    public String getEncoding() {
        if (this.options.contains((Object)Option.ENCODE_UTF16BE)) {
            return "UTF-16BE";
        }
        if (this.options.contains((Object)Option.ENCODE_UTF16LE)) {
            return "UTF-16LE";
        }
        return "UTF-8";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        NO_PACKET_WRAPPER,
        NO_XMPMETA_ELEMENT,
        NO_VERSION_ATTRIBUTE,
        READONLY_PACKET,
        CANONICAL_FORMAT,
        INCLUDE_THUMBNAIL_PAD,
        EXACT_PACKET_LENGTH,
        SORT,
        ENCODE_UTF16BE,
        ENCODE_UTF16LE;

    }
}

