/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.rendercondition;

import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public abstract class AbstractCompositeRenderCondition
implements RenderCondition {
    protected SlingHttpServletRequest request;
    protected SlingHttpServletResponse response;
    protected Resource resource;

    public AbstractCompositeRenderCondition(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) {
        this.request = request;
        this.response = response;
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RenderCondition call(Resource resource) throws ServletException, IOException {
        try {
            ValueMap vm = ResourceUtil.getValueMap(resource);
            String resourceType = vm.get("sling:resourceType", "granite/ui/components/foundation/renderconditions/simple");
            RequestDispatcher dispatcher = this.request.getRequestDispatcher(resource, new RequestDispatcherOptions(resourceType));
            if (dispatcher != null) {
                dispatcher.include((ServletRequest)this.request, (ServletResponse)this.response);
                RenderCondition condition = (RenderCondition)this.request.getAttribute(RenderCondition.class.getName());
                if (condition != null) {
                    RenderCondition renderCondition = condition;
                    return renderCondition;
                }
            }
            RenderCondition renderCondition = SimpleRenderCondition.TRUE;
            return renderCondition;
        }
        finally {
            this.request.removeAttribute(RenderCondition.class.getName());
        }
    }
}

