/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.AttrBuilder;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.LayoutBuilder;
import com.adobe.granite.ui.components.Tag;
import com.adobe.granite.ui.components.Value;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.ResourceDataSource;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.scripting.jsp.util.JspSlingHttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentHelper {
    private PageContext pageContext;
    private SlingBindings bindings;
    private SlingHttpServletRequest request;
    private I18n i18n;
    private XSSAPI xss;
    private Config config;
    private Value value;
    private ExpressionHelper ex;
    private OptionsHolder optionsHolder;

    public ComponentHelper(PageContext pageContext) {
        this.pageContext = pageContext;
        this.bindings = (SlingBindings)pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        this.request = this.bindings.getRequest();
        this.i18n = new I18n(this.request);
        this.xss = this.bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(this.request);
        this.config = new Config(this.request.getResource());
        this.value = new Value(this.request, this.config);
        this.ex = new ExpressionHelper(this.bindings.getSling().getService(ExpressionResolver.class), pageContext);
        this.optionsHolder = (OptionsHolder)this.request.getAttribute(OptionsHolder.class.getName());
        this.request.removeAttribute(OptionsHolder.class.getName());
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public XSSAPI getXss() {
        return this.xss;
    }

    public Config getConfig() {
        return this.config;
    }

    public Value getValue() {
        return this.value;
    }

    public ExpressionHelper getExpressionHelper() {
        return this.ex;
    }

    public Tag consumeTag() {
        Tag tag = this.getOptions().tag();
        return tag == null ? new Tag(new AttrBuilder(this.request, this.xss)) : tag;
    }

    public Options getOptions() {
        if (this.optionsHolder != null && this.optionsHolder.getPath().equals(this.request.getResource().getPath())) {
            return this.optionsHolder.getOptions();
        }
        return new Options();
    }

    public LayoutBuilder getLayout() {
        try {
            return LayoutBuilder.from(this.config, "granite/ui/components/foundation/layouts/container");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getReadOnlyResourceType() {
        return this.getReadOnlyResourceType(this.request.getResource());
    }

    public String getReadOnlyResourceType(Resource resource) {
        String resourceType = new Config(resource).get("sling:resourceType", String.class);
        if (resourceType == null) {
            return null;
        }
        Resource r = this.request.getResourceResolver().getResource(resourceType);
        if (r == null) {
            return null;
        }
        Resource ro = r.getChild("readonly");
        if (ro != null) {
            return ro.getPath();
        }
        return new Config(r).get("granite:readOnlyResourceType", String.class);
    }

    public DataSource getItemDataSource() throws ServletException, IOException {
        return this.getItemDataSource(this.request.getResource());
    }

    public DataSource getItemDataSource(Resource resource) throws ServletException, IOException {
        Config cfg = new Config(resource);
        Resource datasource = cfg.getChild(Config.DATASOURCE);
        if (datasource != null) {
            DataSource ds;
            Config datasourceCfg = new Config(datasource);
            String resourceType = datasourceCfg.get("sling:resourceType", String.class);
            if (resourceType != null && (ds = this.fetchData(resource, resourceType, DataSource.class)) != null) {
                return ds;
            }
            return EmptyDataSource.instance();
        }
        Resource items = cfg.getChild(Config.ITEMS);
        if (items == null) {
            return EmptyDataSource.instance();
        }
        return new ResourceDataSource(items);
    }

    public RenderCondition getRenderCondition() throws ServletException, IOException {
        return this.getRenderCondition(this.request.getResource());
    }

    public RenderCondition getRenderCondition(Resource resource) throws ServletException, IOException {
        Config config = new Config(resource);
        Resource condition = config.getChild(Config.RENDERCONDITION);
        if (condition == null) {
            return SimpleRenderCondition.TRUE;
        }
        Config conditionConfig = new Config(condition);
        String resourceType = conditionConfig.get("sling:resourceType", "granite/ui/components/foundation/renderconditions/simple");
        RenderCondition rc = this.fetchData(condition, resourceType, RenderCondition.class);
        return rc != null ? rc : SimpleRenderCondition.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T fetchData(Resource resource, String resourceType, Class<T> type) throws ServletException, IOException {
        try {
            RequestDispatcher dispatcher = this.request.getRequestDispatcher(resource, new RequestDispatcherOptions(resourceType));
            if (dispatcher != null) {
                dispatcher.include((ServletRequest)this.request, (ServletResponse)new JspSlingHttpServletResponseWrapper(this.pageContext));
                Object object = this.request.getAttribute(type.getName());
                return (T)object;
            }
            T t = null;
            return t;
        }
        finally {
            this.request.removeAttribute(RenderCondition.class.getName());
        }
    }

    public String getIconClass(String icon) {
        if (icon == null) {
            return null;
        }
        if (!icon.startsWith("icon-")) {
            return icon;
        }
        return "coral-Icon--" + this.toCamel(icon.substring(5));
    }

    private String toCamel(String s) {
        String[] parts = s.split("-");
        StringBuilder b = new StringBuilder();
        b.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            b.append(parts[i].substring(0, 1).toUpperCase());
            b.append(parts[i].substring(1));
        }
        return b.toString();
    }

    public void include(Resource resource, Tag tag) throws ServletException, IOException {
        this.include(resource, null, tag);
    }

    public void include(Resource resource, Options options) throws ServletException, IOException {
        this.include(resource, null, options);
    }

    public void include(Resource resource, String resourceType, Tag tag) throws ServletException, IOException {
        this.include(resource, resourceType, new Options().tag(tag));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Resource resource, String resourceType, Options options) throws ServletException, IOException {
        try {
            OptionsHolder holder = new OptionsHolder(options, resource.getPath());
            this.request.setAttribute(OptionsHolder.class.getName(), holder);
            RequestDispatcher dispatcher = this.request.getRequestDispatcher(resource, new RequestDispatcherOptions(resourceType));
            if (dispatcher != null) {
                dispatcher.include((ServletRequest)this.request, (ServletResponse)new JspSlingHttpServletResponseWrapper(this.pageContext));
            }
        }
        finally {
            this.request.removeAttribute(OptionsHolder.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String script, Options options) throws ServletException, IOException {
        try {
            OptionsHolder holder = new OptionsHolder(options, this.request.getResource().getPath());
            this.request.setAttribute(OptionsHolder.class.getName(), holder);
            ServletResolver servletResolver = this.bindings.getSling().getService(ServletResolver.class);
            Servlet servlet = servletResolver.resolveServlet(this.request.getResource(), script);
            if (servlet == null) {
                throw new ServletException("Could not find script " + script);
            }
            servlet.service((ServletRequest)this.request, (ServletResponse)new JspSlingHttpServletResponseWrapper(this.pageContext));
        }
        finally {
            this.request.removeAttribute(OptionsHolder.class.getName());
        }
    }

    public static class Options {
        private Tag tag;
        private boolean rootField = true;

        public Tag tag() {
            return this.tag;
        }

        public Options tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public boolean rootField() {
            return this.rootField;
        }

        public Options rootField(boolean flag) {
            this.rootField = flag;
            return this;
        }
    }

    private class OptionsHolder {
        private Options options;
        private String path;

        public OptionsHolder(Options options, String path) {
            this.options = options;
            this.path = path;
        }

        public Options getOptions() {
            return this.options;
        }

        public String getPath() {
            return this.path;
        }
    }
}

