/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.core.common;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationServiceFactory;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class AbstractTranslationServiceFactory
implements TranslationServiceFactory {
    protected TranslationConstants.ServiceStatus status;
    protected String factoryName;
    private static final Logger log = LoggerFactory.getLogger(AbstractTranslationServiceFactory.class);

    protected void activate(ComponentContext ctx) {
        log.debug("Starting function: activate");
        Dictionary properties = ctx.getProperties();
        this.factoryName = PropertiesUtil.toString(properties.get("translationFactory"), "");
        this.status = TranslationConstants.ServiceStatus.UNKNOWN_STATUS;
        if (log.isDebugEnabled()) {
            log.debug("Activated TSF with the following:");
            log.debug("Factory Name: {}", (Object)this.factoryName);
            log.debug("Status: {}", (Object)this.status.getStatus());
        }
    }

    public TranslationConstants.ServiceStatus getStatus() {
        log.trace("Starting function: getStatus");
        return this.status;
    }

    protected void setStatus(TranslationConstants.ServiceStatus status) {
        log.trace("Starting function: setStatus");
        this.status = status;
    }

    @Override
    public String getServiceFactoryName() {
        log.trace("Starting function: getServiceFactoryName");
        return this.factoryName;
    }
}

