/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.security.user.util;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizableUtil {
    private static Logger log = LoggerFactory.getLogger(AuthorizableUtil.class);
    static final String FAMILY_NAME = "profile/familyName";
    static final String GIVEN_NAME = "profile/givenName";
    @Deprecated
    private static final String PROPERTY_NAME = "rep:fullname";
    @Deprecated
    private static final String PROPERTY_DESCRIPTION = "rep:description";
    @Deprecated
    private static final String PROPERTY_FIRST_NAME = "cq:first-name";
    @Deprecated
    private static final String PROPERTY_LAST_NAME = "cq:last-name";

    public static String getName(Authorizable authorizable) throws RepositoryException {
        return AuthorizableUtil.getName(authorizable, null);
    }

    public static String getFormattedName(ResourceResolver resolver, String userId) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            try {
                String displayName;
                UserProperties props;
                UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
                if (upm != null && (props = upm.getUserProperties(userId, "profile")) != null && StringUtils.isNotEmpty((CharSequence)(displayName = props.getDisplayName()))) {
                    return displayName;
                }
            }
            catch (RepositoryException e) {
                log.warn("Unable to get display name for {}", (Object)userId, (Object)e);
            }
        }
        return userId;
    }

    private static String getName(Authorizable authorizable, UserProperties profile) throws RepositoryException {
        String name;
        String string = name = profile != null ? profile.getDisplayName() : null;
        if (name != null && name.length() > 0) {
            return name;
        }
        name = AuthorizableUtil.getProperty(authorizable, GIVEN_NAME, PROPERTY_FIRST_NAME);
        if (authorizable.isGroup()) {
            if (name != null && name.length() > 0) {
                return name;
            }
            name = AuthorizableUtil.getProperty(authorizable, PROPERTY_NAME);
            if (name != null && name.length() > 0) {
                return name;
            }
            name = AuthorizableUtil.getProperty(authorizable, PROPERTY_DESCRIPTION);
            if (name != null && name.length() > 0) {
                return name;
            }
        } else {
            String familyName;
            StringBuilder buf = new StringBuilder();
            if (name != null) {
                buf.append(name);
            }
            if ((familyName = AuthorizableUtil.getProperty(authorizable, FAMILY_NAME, PROPERTY_LAST_NAME)) != null && familyName.length() > 0) {
                buf.append(" ").append(familyName);
            }
            if (buf.length() > 0) {
                return buf.toString();
            }
        }
        return authorizable.getID();
    }

    private static String getProperty(Authorizable authorizable, String propertyName) {
        return AuthorizableUtil.getProperty(authorizable, propertyName, null);
    }

    private static String getProperty(Authorizable authorizable, String propertyName, String fallbackName) {
        try {
            Value[] vs;
            if (authorizable.hasProperty(propertyName) && (vs = authorizable.getProperty(propertyName)) != null && vs.length > 0) {
                return vs[0].getString();
            }
            if (fallbackName != null && authorizable.hasProperty(fallbackName) && (vs = authorizable.getProperty(fallbackName)) != null && vs.length > 0) {
                return vs[0].getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }
}

