/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.offloading.workflow.api;

import com.adobe.granite.offloading.workflow.api.JobOffloadingProcessArguments;
import com.adobe.granite.offloading.workflow.api.WorkflowOffloadingProcessArguments;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public final class WorkflowOffloadingHelper {
    private static final String OFFLOADING_PAYLOAD_DELIMITER = ",";

    public static String getJobTopic(MetaDataMap arguments) {
        if (arguments != null) {
            return (String)((Object)arguments.get(JobOffloadingProcessArguments.JOB_TOPIC.getArgumentName(), String.class));
        }
        return null;
    }

    public static ValueMap getJobProperties(MetaDataMap arguments) {
        ValueMapDecorator jobProperties = new ValueMapDecorator(new HashMap<String, Object>());
        if (arguments != null) {
            String[] properties;
            for (String property : properties = arguments.get(JobOffloadingProcessArguments.JOB_PROPERTIES.getArgumentName(), new String[0])) {
                String[] split = property.split("\\|");
                if (split.length != 2) continue;
                jobProperties.put(split[0], split[1]);
            }
        }
        return jobProperties;
    }

    public static String[] getOffloadingInput(MetaDataMap arguments) {
        if (arguments != null) {
            return arguments.get(JobOffloadingProcessArguments.OFFLOADING_INPUT.getArgumentName(), new String[0]);
        }
        return new String[0];
    }

    public static String[] getOffloadingOutput(MetaDataMap arguments) {
        if (arguments != null) {
            return arguments.get(JobOffloadingProcessArguments.OFFLOADING_OUTPUT.getArgumentName(), new String[0]);
        }
        return new String[0];
    }

    public static String convertToOffloadingPayload(String[] offloadingPayload) {
        StringBuffer inputBuffer = new StringBuffer();
        if (offloadingPayload != null && offloadingPayload.length > 0) {
            for (String path : offloadingPayload) {
                inputBuffer.append(path).append(OFFLOADING_PAYLOAD_DELIMITER);
            }
        }
        return inputBuffer.toString();
    }

    public static String getWorkflowModel(MetaDataMap arguments) {
        if (arguments != null) {
            return (String)((Object)arguments.get(WorkflowOffloadingProcessArguments.WORKFLOW_MODEL.getArgumentName(), String.class));
        }
        return null;
    }

    public static String getWorkflowPayload(String fallbackPayload, MetaDataMap arguments) {
        String payload = null;
        if (arguments != null && StringUtils.isBlank((String)(payload = (String)((Object)arguments.get(WorkflowOffloadingProcessArguments.WORKFLOW_PAYLOAD.getArgumentName(), String.class))))) {
            payload = fallbackPayload;
        }
        return payload;
    }

    public static boolean doTransportWorkflowModelWithInput(MetaDataMap arguments) {
        if (arguments != null) {
            return arguments.get(WorkflowOffloadingProcessArguments.OFFLOADING_INPUT_WORKFLOW_MODEL.getArgumentName(), Boolean.FALSE);
        }
        return false;
    }

    public static boolean doTransportWorkflowModelWithOutput(MetaDataMap arguments) {
        if (arguments != null) {
            return arguments.get(WorkflowOffloadingProcessArguments.OFFLOADING_OUTPUT_WORKFLOW_MODEL.getArgumentName(), Boolean.FALSE);
        }
        return false;
    }

    public static boolean doTransportWorkflowPayloadWithInput(MetaDataMap arguments) {
        if (arguments != null) {
            return arguments.get(JobOffloadingProcessArguments.OFFLOADING_INPUT_WORKFLOW_PAYLOAD.getArgumentName(), Boolean.FALSE);
        }
        return false;
    }

    public static boolean doTransportWorkflowPayloadWithOutput(MetaDataMap arguments) {
        if (arguments != null) {
            return arguments.get(JobOffloadingProcessArguments.OFFLOADING_OUTPUT_WORKFLOW_PAYLOAD.getArgumentName(), Boolean.FALSE);
        }
        return false;
    }

    public static String getWorkflowOffloadingInput(MetaDataMap arguments, String workflowPayload, String workflowModel) {
        String offloadingInputPayload = null;
        if (arguments != null) {
            Object[] fromArguments = WorkflowOffloadingHelper.getOffloadingInput(arguments);
            ArrayList<String> offloadingInput = new ArrayList<String>();
            if (WorkflowOffloadingHelper.doTransportWorkflowPayloadWithInput(arguments) && StringUtils.isNotBlank((String)workflowPayload)) {
                offloadingInput.add(workflowPayload);
            }
            if (WorkflowOffloadingHelper.doTransportWorkflowModelWithInput(arguments) && StringUtils.isNotBlank((String)workflowModel)) {
                offloadingInput.add(workflowModel);
            }
            Object[] offloadingInputArray = offloadingInput.toArray(new String[offloadingInput.size()]);
            String[] all = (String[])ArrayUtils.addAll((Object[])fromArguments, (Object[])offloadingInputArray);
            offloadingInputPayload = WorkflowOffloadingHelper.convertToOffloadingPayload(all);
        }
        return offloadingInputPayload;
    }

    public static String getWorkflowOffloadingOutput(MetaDataMap arguments, String workflowPayload, String workflowModel) {
        String offloadingOutputPayload = null;
        if (arguments != null) {
            Object[] fromArguments = WorkflowOffloadingHelper.getOffloadingOutput(arguments);
            ArrayList<String> offloadingOutput = new ArrayList<String>();
            if (WorkflowOffloadingHelper.doTransportWorkflowPayloadWithOutput(arguments) && StringUtils.isNotBlank((String)workflowPayload)) {
                offloadingOutput.add(workflowPayload);
            }
            if (WorkflowOffloadingHelper.doTransportWorkflowModelWithOutput(arguments) && StringUtils.isNotBlank((String)workflowModel)) {
                offloadingOutput.add(workflowModel);
            }
            Object[] offloadingOutputArray = offloadingOutput.toArray(new String[offloadingOutput.size()]);
            String[] all = (String[])ArrayUtils.addAll((Object[])fromArguments, (Object[])offloadingOutputArray);
            offloadingOutputPayload = WorkflowOffloadingHelper.convertToOffloadingPayload(all);
        }
        return offloadingOutputPayload;
    }
}

