/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.comments;

import com.adobe.granite.comments.Comment;
import com.adobe.granite.comments.CommentCollection;
import com.adobe.granite.comments.CommentManager;
import com.adobe.granite.comments.CommentingEvent;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="Granite Comment Operation Handler")
@Service
@Properties(value={@Property(name="sling.post.operation", value={"granite:comment"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="sling.servlet.extensions", value={"html", "json"})})
public class CommentingOperationHandler
implements PostOperation {
    private static final long serialVersionUID = -5076236106916461224L;
    private static final Logger log = LoggerFactory.getLogger(CommentingOperationHandler.class);
    @Reference
    private CommentManager cm = null;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private EventAdmin eventAdmin = null;
    private final String DEFAULT_CREATOR = "anonymous";
    private final String MESSAGE = "message";
    private final String ANNOTATION_DATA = "annotationData";

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        String createdBy;
        Resource resource = request.getResource();
        try {
            createdBy = this.getAuthor(request);
        }
        catch (RepositoryException re) {
            log.error("Unable to find ID of author", (Throwable)re);
            response.setError(re);
            return;
        }
        String path = resource.getPath();
        String message = request.getParameter("message");
        String annotationData = request.getParameter("annotationData");
        try {
            Comment comment = this.createComment(resource, path, message, annotationData, createdBy);
            EventAdmin ea = this.eventAdmin;
            if (ea != null && comment != null) {
                ea.postEvent(CommentingEvent.commented(comment.getPath()).toEvent());
            } else if (ea != null) {
                log.debug("event admin is null");
            } else {
                log.debug("comment could not be created");
            }
        }
        catch (Exception e) {
            log.error("Unable to create comment.", (Throwable)e);
            response.setError(e);
        }
    }

    private String getAuthor(SlingHttpServletRequest request) throws RepositoryException {
        Authorizable auth = request.getResourceResolver().adaptTo(Authorizable.class);
        String createdBy = "anonymous";
        if (auth != null) {
            createdBy = auth.getID();
        }
        return createdBy;
    }

    private Comment createComment(Resource resource, String path, String message, String annotationData, String createdBy) throws Exception {
        if (path == null || message == null) {
            throw new IllegalArgumentException("Path and message may not be null");
        }
        return this.cm.getOrCreateCollection(resource, CommentCollection.class).addComment(message, createdBy, annotationData);
    }

    void bindEventAdmin(EventAdmin ea) {
        this.eventAdmin = ea;
        log.debug("binding Event Admin");
    }

    void unbindEventAdmin(EventAdmin ea) {
        this.eventAdmin = null;
        log.debug("un-binding Event Admin");
    }

    protected void bindCm(CommentManager commentManager) {
        this.cm = commentManager;
    }

    protected void unbindCm(CommentManager commentManager) {
        if (this.cm == commentManager) {
            this.cm = null;
        }
    }
}

