/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.comments;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.granite.comments.AbstractCommentCollection;
import com.adobe.granite.comments.AbstractCommentingProvider;
import com.adobe.granite.comments.Comment;
import com.adobe.granite.comments.CommentCollection;
import com.adobe.granite.comments.CommentException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConsumerType
public abstract class AbstractComment
implements Comment {
    private final AbstractCommentCollection collection;
    private final Resource resource;
    private final AbstractCommentingProvider provider;
    private final ValueMap properties;

    protected AbstractComment(AbstractCommentCollection collection, Resource resource, AbstractCommentingProvider provider) {
        this.collection = collection;
        this.resource = resource;
        this.provider = provider;
        this.properties = resource.adaptTo(ValueMap.class);
    }

    @Override
    public final Resource addAttachment(String name, InputStream inputStream, String mimeType) throws CommentException {
        if (null == inputStream) {
            throw new IllegalArgumentException("input stream may not be null");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name may not be null or empty");
        }
        if (StringUtils.isBlank((String)mimeType)) {
            throw new IllegalArgumentException("mimetype may not be null or empty");
        }
        return this.provider.createAttachmentResource(this.getResource(), name, inputStream, mimeType);
    }

    @Override
    public final String getAnnotationData() {
        return (String)((Object)this.properties.get("annotationData", String.class));
    }

    @Override
    public final Resource getAttachment(String name) {
        return this.provider.getAttachmentResource(this.getResource(), name);
    }

    @Override
    public final String getAuthorName() {
        String author = (String)((Object)this.properties.get("author", String.class));
        return null != author ? author : this.getCreatedBy();
    }

    @Override
    public final Map<String, Resource> getAttachmentMap() {
        return Collections.unmodifiableMap(this.provider.getAttachmentMap(this.getResource()));
    }

    private final String getCreatedBy() {
        return (String)((Object)this.properties.get("jcr:createdBy", String.class));
    }

    @Override
    public final Calendar getCreated() {
        return (Calendar)((Object)this.properties.get("jcr:created", Calendar.class));
    }

    @Override
    public final Calendar getLastModified() {
        return (Calendar)((Object)this.properties.get("jcr:lastModified", Calendar.class));
    }

    @Override
    public final String getMessage() {
        return (String)((Object)this.properties.get("jcr:description", String.class));
    }

    @Override
    public final CommentCollection getCollection() {
        return this.collection;
    }

    @Override
    public final String getPath() {
        return this.getResource().getPath();
    }

    @Override
    public final ValueMap getProperties() {
        return this.properties;
    }

    @Override
    public final void removeAttachment(String name) throws CommentException {
        this.provider.removeAttachmentResource(this.getResource(), name);
    }

    @Override
    public final void remove() {
        this.collection.removeComment(this);
    }

    protected Resource getResource() {
        return this.resource;
    }
}

