/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.cloudsettings;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudSettingsUtil {
    public static String getPersonDisplayName(ResourceResolver resolver, String userId) {
        String displayName = null;
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            try {
                InternetAddress[] addresses = InternetAddress.parse((String)userId);
                if (addresses.length > 0) {
                    userId = addresses[0].getAddress();
                    displayName = addresses[0].getPersonal();
                }
            }
            catch (AddressException e) {
                // empty catch block
            }
            try {
                String profileDisplayName;
                Resource profileRes;
                UserProperties profile = null;
                UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
                UserManager um = resolver.adaptTo(UserManager.class);
                Authorizable authorizable = um.getAuthorizable(userId);
                String authorizablePath = authorizable.getPath();
                if (authorizablePath != null && (profileRes = resolver.getResource(authorizablePath + "/profile")) != null) {
                    profile = upm.getUserProperties(profileRes.adaptTo(Node.class));
                }
                if (profile != null && !StringUtils.isEmpty((CharSequence)(profileDisplayName = profile.getDisplayName()))) {
                    displayName = profileDisplayName;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty(displayName)) {
            displayName = userId;
        }
        return displayName;
    }

    public static Iterator<Resource> getCloudSettingsConfigTypes(ResourceResolver resolver, Resource parentResource) {
        CloudSettingsConfigTypeFilter predicate = new CloudSettingsConfigTypeFilter(parentResource);
        return new FilterIterator(resolver.findResources("SELECT * FROM [granite:CloudsettingsConfigType]", "JCR-SQL2"), (Predicate)predicate);
    }

    private static class CloudSettingsConfigTypeFilter
    implements Predicate {
        private Resource parentResource;

        public CloudSettingsConfigTypeFilter(Resource parentResource) {
            this.parentResource = parentResource;
        }

        public boolean evaluate(Object object) {
            if (object instanceof Resource) {
                Object allowedParentType;
                Resource configType = (Resource)object;
                if (!configType.getPath().startsWith("/apps") && !configType.getPath().startsWith("/libs")) {
                    return false;
                }
                ValueMap configTypeVm = ResourceUtil.getValueMap(configType);
                String uniqueName = (String)((Object)configTypeVm.get("uniqueName", String.class));
                if (StringUtils.isNotEmpty((CharSequence)uniqueName) && this.parentResource.getChild(uniqueName) != null) {
                    return false;
                }
                ResourceResolver resourceResolver = this.parentResource.getResourceResolver();
                Object[] allowedParentTypes = configTypeVm.get("allowedParentTypes", new String[0]);
                boolean isParentAllowed = ArrayUtils.isEmpty((Object[])allowedParentTypes);
                Object[] arr$ = allowedParentTypes;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(isParentAllowed = resourceResolver.isResourceType(this.parentResource, (String)(allowedParentType = arr$[i$]))); ++i$) {
                }
                ValueMap parentTypeVm = ResourceUtil.getValueMap(resourceResolver.getResource(this.parentResource.getResourceType()));
                Object[] allowedChildTypes = parentTypeVm.get("allowedChildTypes", new String[0]);
                boolean isChildAllowed = ArrayUtils.isEmpty((Object[])allowedChildTypes);
                for (Object allowedChildType : allowedChildTypes) {
                    SyntheticResource configTypeRes = new SyntheticResource(resourceResolver, "testRes", configType.getPath());
                    isChildAllowed = resourceResolver.isResourceType(configTypeRes, (String)allowedChildType);
                    if (isChildAllowed) break;
                }
                return isParentAllowed && isChildAllowed;
            }
            return false;
        }
    }
}

