/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.util;

import com.adobe.granite.auth.saml.util.KeyProvider;
import com.adobe.granite.auth.saml.util.io.Siphon;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;

public class SlingKeyProvider
implements KeyProvider {
    static final String KEY_ROOT = "/etc/key/saml";
    static final String PRIVATE_KEY = "private";
    static final String PUBLIC_CERT = "public";
    private ResourceResolverFactory resourceResolverFactory;
    private Siphon siphon = new Siphon();

    public void setResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    public Key getDecryptionKey() {
        ResourceResolver resourceResolver = null;
        InputStream privateStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource keyRoot = resourceResolver.getResource(KEY_ROOT);
            ValueMap valueMap = keyRoot.adaptTo(ValueMap.class);
            if (!valueMap.containsKey(PRIVATE_KEY)) {
                Key key = null;
                return key;
            }
            privateStream = (InputStream)((Object)valueMap.get(PRIVATE_KEY, InputStream.class));
            outputStream = new ByteArrayOutputStream();
            this.siphon.siphon(privateStream, outputStream);
            byte[] privateBytes = outputStream.toByteArray();
            if (null == privateBytes || 0 == privateBytes.length) {
                Key e = null;
                return e;
            }
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(privateBytes);
            PrivateKey privateKey = keyFactory.generatePrivate(ks);
            return privateKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error reading private key", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Error reading private key", e);
        }
        catch (LoginException e) {
            throw new RuntimeException("Unable to retrieve admin resource resolver", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading private key", e);
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
            if (null != privateStream) {
                try {
                    privateStream.close();
                }
                catch (IOException e) {}
            }
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    public Certificate getPublicCertificate() {
        ResourceResolver resourceResolver = null;
        InputStream inputStream = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource keyRoot = resourceResolver.getResource(KEY_ROOT);
            ValueMap valueMap = keyRoot.adaptTo(ValueMap.class);
            inputStream = (InputStream)((Object)valueMap.get(PUBLIC_CERT, InputStream.class));
            if (null == inputStream) {
                throw new RuntimeException("Public key has not been configured - please contact your administrator");
            }
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certFactory.generateCertificate(inputStream);
            return certificate;
        }
        catch (LoginException e) {
            throw new RuntimeException("Unable to retrieve admin resource resolver", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Error reading certificate", e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (null != resourceResolver) {
                resourceResolver.close();
            }
        }
    }
}

