/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.launches.utils;

import com.day.text.Text;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;

public class LaunchUtils {
    private static final int LAUNCH_NAME_LEVEL = 2;

    public static Resource getLaunchResource(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        String launchPath = LaunchUtils.getLaunchPath(resource.getPath());
        return launchPath != null ? resource.getResourceResolver().getResource(launchPath) : null;
    }

    public static String getLaunchPath(String path) {
        if (LaunchUtils.isLaunchBasedPath(path)) {
            String launchPath = Text.getAbsoluteParent(path, 2);
            return StringUtils.isNotEmpty((String)launchPath) ? launchPath : null;
        }
        return null;
    }

    public static String getLaunchPathFromName(String launchName) {
        return Text.makeCanonicalPath("/content/launches/" + launchName);
    }

    public static String getProductionResourcePath(String path) {
        return LaunchUtils.isLaunchResourcePath(path) ? StringUtils.substringAfter((String)path, (String)LaunchUtils.getLaunchPath(path)) : path;
    }

    public static boolean isLaunchBasedPath(String path) {
        return Text.isDescendantOrEqual("/content/launches", path);
    }

    static boolean isLaunchBasedPath(String path, String launchPath) {
        return Text.isDescendantOrEqual(launchPath, path);
    }

    public static boolean isLaunchResourcePath(String path) {
        return LaunchUtils.isLaunchBasedPath(path) && StringUtils.isNotEmpty((String)Text.getAbsoluteParent(path, 3));
    }

    public static String buildLaunchResourcePath(String path, String launchName) {
        if (LaunchUtils.isLaunchResourcePath(path)) {
            return LaunchUtils.isLaunchBasedPath(path, LaunchUtils.getLaunchPathFromName(launchName)) ? path : null;
        }
        return !LaunchUtils.isLaunchBasedPath(path) ? Text.makeCanonicalPath("/content/launches/" + launchName + "/" + path) : null;
    }
}

