/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugcbase;

import com.adobe.cq.social.ugcbase.SocialResource;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocialResourceUtils {
    private static String ASI_UGC_PREFIX = "/content/usergenerated/asi";
    private static final Logger LOG = LoggerFactory.getLogger(SocialResourceUtils.class);

    private SocialResourceUtils() {
    }

    public static Boolean checkPermission(ResourceResolver resolver, String path, String action) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        try {
            Session userSession = resolver.adaptTo(Session.class);
            return userSession.hasPermission(path, action);
        }
        catch (RepositoryException e) {
            return SocialResourceUtils.checkPermission(resolver, StringUtils.substringBeforeLast((String)path, (String)"/"), action);
        }
    }

    public static UserProperties getUserProperties(ResourceResolver resolver, String userId) {
        UserProperties userProperties = null;
        UserPropertiesManager upm = resolver.adaptTo(UserPropertiesManager.class);
        if (null != upm && null != userId) {
            try {
                userProperties = upm.getUserProperties(userId, "profile");
            }
            catch (RepositoryException e) {
                LOG.warn("User cannot access the profile.", (Throwable)e);
            }
        }
        return userProperties;
    }

    public static String getAvatar(UserProperties userProperties, String absoluteDefaultAvatar, SocialUtils.AVATAR_SIZE size) {
        return SocialResourceUtils.buildAvatar(userProperties, absoluteDefaultAvatar, size.toString());
    }

    private static String buildAvatar(UserProperties userProperties, String absoluteDefaultAvatar, String size) {
        String avatar = "/etc/designs/default/images/social/avatar.png";
        int iSize = SocialUtils.AVATAR_SIZE.THIRTY_TWO.ordinal();
        try {
            iSize = Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            LOG.warn("Bad size passed in, defaulting size.", (Throwable)e);
        }
        if (userProperties != null) {
            try {
                Resource resource = userProperties.getResource("photos/primary/image");
                if (null != resource) {
                    avatar = resource.getPath() + ".prof.thumbnail." + Integer.toString(iSize) + ".png";
                } else {
                    String gravatar;
                    String primaryMail = userProperties.getProperty("email");
                    if (primaryMail != null && !"".equals(primaryMail) && (gravatar = SocialResourceUtils.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                        avatar = gravatar;
                    }
                }
            }
            catch (RepositoryException e) {
                LOG.error("getAvatar: error getting avatar: ", (Throwable)e);
            }
        }
        return avatar;
    }

    private static String getGravatar(String email, String absoluteDefaultAvatar) {
        if (StringUtils.isBlank((CharSequence)email) || StringUtils.isBlank((CharSequence)absoluteDefaultAvatar)) {
            return null;
        }
        try {
            Text.md5(email, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://www.gravatar.com/avatar/");
        sb.append(email);
        sb.append("?d=").append("mm");
        sb.append("&s=32");
        sb.append("&r=g");
        return sb.toString();
    }

    public static boolean isCloudUGC(String path) {
        return StringUtils.startsWith((CharSequence)path, (CharSequence)ASI_UGC_PREFIX);
    }

    public static boolean isSocialResource(Resource res) {
        if (res instanceof SocialResource) {
            return true;
        }
        if (res instanceof ResourceWrapper) {
            return SocialResourceUtils.isSocialResource(((ResourceWrapper)res).getResource());
        }
        return false;
    }

    public static SocialResource getSocialResource(Resource res) {
        if (res instanceof SocialResource) {
            return (SocialResource)res;
        }
        if (res instanceof ResourceWrapper) {
            return SocialResourceUtils.getSocialResource(((ResourceWrapper)res).getResource());
        }
        if (res instanceof NonExistingResource) {
            LOG.warn("Resource {} is a NonExistingResource, returning null", (Object)res);
            return null;
        }
        LOG.warn("Resource {} is unknown resource type, returning null", (Object)res);
        return null;
    }

    public static boolean causeByInvalidItemStateException(Exception e) {
        Throwable cause = e;
        do {
            if (!(cause instanceof InvalidItemStateException)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }
}

