/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.translation;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.translation.TranslationResults;
import com.adobe.cq.social.translation.TranslationUpdate;
import com.adobe.cq.social.translation.TranslationVariables;
import com.adobe.cq.social.translation.UGCTranslationMeta;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationManager;
import com.adobe.granite.translation.api.TranslationResult;
import com.adobe.granite.translation.api.TranslationService;
import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.MachineTranslationUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationUtil.class);
    public static final String TRANSLATION_NODE_NAME = "translation";
    public static final String LANGUAGE_PROP = "language";
    public static final String TRANSLATION_DATE_PROP = "translationDate";
    public static final String LANGUAGE_DETECTED_DATE_PROP = "languageDetectedDate";
    public static final String POST_EDITED_PROP = "postEdited";
    public static final String JCR_CONTENT_STR = "_jcr_content";
    private static final String NT_SLINGFOLDER = "sling:Folder";

    public static String addLanguageCode(Resource resource, Session session, String property, TranslationConstants.ContentType contentType, TranslationManager tm) {
        LOG.trace("In function: addLanguageCode");
        String lanCode = null;
        ValueMap resourceProperties = resource.adaptTo(ModifiableValueMap.class);
        String determineString = null;
        if (property != null) {
            determineString = resourceProperties.get(property, (String)null);
        }
        try {
            if (determineString != null) {
                lanCode = TranslationUtil.getLanguageCode(determineString, contentType, resource, tm);
                if (lanCode != null) {
                    Resource translationNode = TranslationUtil.getTranslationNode(resource, session);
                    if (translationNode != null) {
                        ValueMap translationNodeProperties = translationNode.adaptTo(ModifiableValueMap.class);
                        translationNodeProperties.put(LANGUAGE_PROP, lanCode);
                        resourceProperties.put(LANGUAGE_DETECTED_DATE_PROP, new GregorianCalendar());
                        if (session != null) {
                            session.save();
                        }
                    }
                } else {
                    LOG.debug("Either the session or the translation node were null, not saving");
                }
            }
        }
        catch (RepositoryException e) {
            LOG.error("Error setting language property", (Throwable)e);
        }
        return lanCode;
    }

    private static Resource getTranslationNode(Resource resource, Session session) {
        LOG.trace("In getTranslationNode");
        Resource translationNode = null;
        try {
            translationNode = resource.getChild(TRANSLATION_NODE_NAME);
            if (translationNode == null && session != null) {
                LOG.debug("Didn't find Translation node, creating");
                Node resourceNode = resource.adaptTo(Node.class);
                resourceNode.addNode(TRANSLATION_NODE_NAME, NT_SLINGFOLDER);
                LOG.debug("Saving session");
                session.save();
                translationNode = resource.getChild(TRANSLATION_NODE_NAME);
            }
        }
        catch (Exception e) {
            LOG.warn("Translation node might not exist");
        }
        return translationNode;
    }

    public static String getLanguageCode(String content, TranslationConstants.ContentType contentType, Resource resource, TranslationManager tm) {
        LOG.debug("In function: getLanguageCode");
        String lanCode = null;
        try {
            if (tm != null) {
                TranslationService ts = tm.createTranslationService(TranslationUtil.getNonUgcResource(resource));
                if (ts != null) {
                    lanCode = ts.detectLanguage(content, contentType);
                } else {
                    LOG.debug("TranslationService was null for resource: {}", (Object)resource.getPath());
                }
            } else {
                LOG.debug("TranslationManager was null, returning null for detected string");
            }
        }
        catch (TranslationException te) {
            if (te.getErrorCode() == TranslationException.ErrorCode.MISSING_CREDENTIALS) {
                LOG.debug("Applied credentials were null or blank.  The default configuration might be applied");
            }
            LOG.error(te.toString());
        }
        LOG.debug("lanCode: {}", lanCode);
        return lanCode;
    }

    public static Resource getNonUgcResource(Resource resource) {
        Page nonUgcPage;
        LOG.trace("In Function: getNonUgcResource");
        ResourceResolver rr = resource.getResourceResolver();
        SocialUtils socialUtils = rr.adaptTo(SocialUtils.class);
        if (socialUtils != null && (nonUgcPage = socialUtils.getContainingPage(resource)) != null) {
            String nonUgcPath = nonUgcPage.getPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug("resource.getPath(): {}", (Object)resource.getPath());
                LOG.debug("nonUgcPath: {}", (Object)nonUgcPath);
            }
            if (StringUtils.equals((String)rr.map(resource.getPath()), (String)nonUgcPath)) {
                return resource;
            }
            LOG.debug("Using non UGC resource");
            if (StringUtils.contains((String)nonUgcPath, (String)JCR_CONTENT_STR)) {
                nonUgcPath = StringUtils.substringBeforeLast((String)nonUgcPath, (String)JCR_CONTENT_STR);
            }
            LOG.debug("nonUgcPath AFTER: {}", (Object)nonUgcPath);
            Resource nonUgcResource = rr.resolve(nonUgcPath);
            if (nonUgcResource != null) {
                return nonUgcResource;
            }
            LOG.warn("Cannot get the associated content resource");
        }
        return resource;
    }

    public static boolean doDisplayTranslation(ResourceResolver resourceResolver, Resource resource, ClientUtilities clientUtils) {
        if (resourceResolver == null) {
            return false;
        }
        String ugcLan = TranslationUtil.getUGCLanguage(resource);
        boolean languageSupported = false;
        for (String supportLan : TranslationVariables.getLanguageCode()) {
            if (!TranslationUtil.languagesAreEquivalent(supportLan, ugcLan).booleanValue()) continue;
            languageSupported = true;
            break;
        }
        LOG.debug("Comment user: {}", (Object)clientUtils.getAuthorizedUserId());
        String toLang = TranslationUtil.getUserLanguage(resourceResolver, clientUtils.getAuthorizedUserId());
        if (toLang == null || "".equals(toLang)) {
            toLang = clientUtils != null && clientUtils.getRequest() != null ? TranslationUtil.getPageLanguage(resourceResolver, TranslationUtil.getNonUgcResource(resource), clientUtils.getRequest().getRequestURI(), clientUtils.getRequest().getHeader("referer")) : TranslationUtil.getPageLanguage(resourceResolver, TranslationUtil.getNonUgcResource(resource), null, null);
        }
        if (ugcLan == null || toLang == null) {
            return false;
        }
        return languageSupported && TranslationUtil.languagesAreEquivalent(ugcLan, toLang) == false;
    }

    public static String getUserLanguage(ResourceResolver resourceResolver, String userId) {
        String userLanguage = "";
        UserPropertiesManager userPropertiesManager = resourceResolver.adaptTo(UserPropertiesManager.class);
        if (userPropertiesManager != null) {
            try {
                UserProperties userProps = null;
                if (userId != null && !"".equals(userId)) {
                    userProps = userPropertiesManager.getUserProperties(userId, "preferences");
                } else {
                    LOG.debug("Getting language for user {}", (Object)resourceResolver.getUserID());
                    userProps = userPropertiesManager.getUserProperties(resourceResolver.getUserID(), "preferences");
                }
                if (userProps != null) {
                    userLanguage = userProps.getProperty(LANGUAGE_PROP);
                }
            }
            catch (RepositoryException re) {
                LOG.error(re.toString());
            }
        }
        return userLanguage;
    }

    public static String getUGCLanguage(Resource resource) {
        ValueMap properties = null;
        if (resource != null) {
            Resource translationNode = TranslationUtil.getTranslationNode(resource, null);
            if (translationNode != null) {
                properties = translationNode.adaptTo(ValueMap.class);
                return properties.get(LANGUAGE_PROP, (String)null);
            }
            LOG.debug("translationNode was null");
        } else {
            LOG.error("resource was null");
        }
        return null;
    }

    public static String getPageLanguage(ResourceResolver resourceResolver, Resource ugcResource, String uri, String referer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("uri: {}", (Object)uri);
            LOG.debug("referer: {}", (Object)referer);
        }
        if (resourceResolver == null) {
            LOG.warn("resourceResolver was null!");
            return null;
        }
        String pageLang = "";
        if (uri != null && !"".equals(uri)) {
            Resource uriResource;
            String uriResourcePath = TranslationUtil.uriToResourcePath(uri);
            LOG.debug("uriResourcePath: {}", (Object)uriResourcePath);
            if (!uriResourcePath.startsWith("/content/usergenerated") && (uriResource = resourceResolver.getResource(uriResourcePath)) != null) {
                LOG.debug("Getting pageLang from uri");
                pageLang = TranslationUtil.getResourceLanguage(resourceResolver, uriResource);
            }
        }
        if (pageLang == null || "".equals(pageLang)) {
            Resource commentsNodeResource = TranslationUtil.getNonUgcResource(ugcResource);
            MachineTranslationUtil mtu = resourceResolver.adaptTo(MachineTranslationUtil.class);
            MachineTranslationCloudConfig cloudConfig = mtu.getAppliedMachineTranslationCloudConfigs(commentsNodeResource);
            if (cloudConfig != null) {
                LOG.debug("Getting pageLang from user");
                pageLang = TranslationUtil.getUserLanguage(resourceResolver, null);
            } else {
                LOG.debug("Getting pageLang from UGC");
                pageLang = TranslationUtil.getResourceLanguage(resourceResolver, ugcResource);
            }
        }
        if (pageLang == null || "".equals(pageLang)) {
            LOG.debug("Getting pageLang from referer");
            pageLang = TranslationUtil.uriToResourcePath(referer);
        }
        return pageLang;
    }

    public static String getResourceLanguage(ResourceResolver rr, Resource resource) {
        Page containingPage;
        PageManager pm = rr.adaptTo(PageManager.class);
        Page page = containingPage = pm != null ? pm.getContainingPage(resource) : null;
        if (containingPage == null) {
            return null;
        }
        Page parentPage = containingPage.getParent(1);
        if (parentPage == null) {
            return null;
        }
        Locale language = parentPage.getLanguage(false);
        return language == null ? null : language.getLanguage();
    }

    public static String uriToResourcePath(String uri) {
        if (uri == null || "".equals(uri)) {
            return null;
        }
        String resourcePath = "";
        int slashslash = uri.indexOf("//");
        resourcePath = slashslash > -1 ? uri.substring(uri.indexOf(47, slashslash + 2)) : uri;
        return StringUtils.substringBefore((String)resourcePath, (String)".");
    }

    public static UGCTranslationMeta ugcTranslationMeta(ResourceResolver resourceResolver, Resource resource, String toLanguage, String[] properties, String pagePath, String userId) {
        LOG.trace("In function: ugcTranslationMeta");
        UGCTranslationMeta meta = new UGCTranslationMeta();
        String ugcLan = "";
        String pageLanguage = "";
        if (userId != null && !"".equals(userId)) {
            pageLanguage = TranslationUtil.getUserLanguage(resourceResolver, userId);
        }
        if (pageLanguage == null || "".equals(pageLanguage)) {
            pageLanguage = TranslationUtil.getPageLanguage(resourceResolver, TranslationUtil.getNonUgcResource(resource), pagePath, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pageLanguage: {}", (Object)pageLanguage);
            LOG.debug("resource path: {}", (Object)resource.getPath());
        }
        meta.setPageLanguage(pageLanguage);
        ugcLan = TranslationUtil.getUGCLanguage(resource);
        if (ugcLan != null) {
            LOG.debug("ugcLan: {}", (Object)ugcLan);
            for (String supportLan : TranslationVariables.getLanguageCode()) {
                if (!TranslationUtil.languagesAreEquivalent(supportLan, ugcLan).booleanValue()) continue;
                meta.setUgcLanuage(ugcLan);
            }
        } else {
            LOG.warn("ugcLang returned null");
        }
        if (properties != null && properties.length > 0) {
            ValueMap commentProperties = resource.adaptTo(ValueMap.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("commentProperties: {}", commentProperties.keySet());
            }
            ArrayList<String> toBeTranslated = new ArrayList<String>();
            for (String property : properties) {
                String prop;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checking for property: {}", (Object)property);
                }
                if ((prop = commentProperties.get(property, (String)null)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding prop {} to toBeTranslated ArrayList", (Object)prop);
                }
                toBeTranslated.add(prop);
            }
            meta.setToBeTranslated(toBeTranslated);
        } else {
            LOG.warn("properties was null");
        }
        return meta;
    }

    public static TranslationResult getTranslation(String fromLan, String toLan, String str, Resource resource, TranslationManager tm) {
        LOG.debug("In function: getTranslationFromAPI");
        TranslationResult result = null;
        if (TranslationUtil.languagesAreEquivalent(fromLan, toLan).booleanValue()) {
            LOG.debug("From language is the same as to language, returning null TranslationResult", (Object)fromLan);
            return null;
        }
        try {
            if (tm != null) {
                TranslationService ts = tm.createTranslationService(TranslationUtil.getNonUgcResource(resource));
                if (ts != null) {
                    result = ts.translateString(str, fromLan, toLan, TranslationConstants.ContentType.HTML, "general");
                } else {
                    LOG.warn("Failed to get a Translation Service for resource path: {}", (Object)resource.getPath());
                }
            } else {
                LOG.warn("TranslationManager was null");
            }
        }
        catch (TranslationException te) {
            LOG.error(te.toString());
        }
        return result;
    }

    public static void saveTranslation(String toLan, Map<String, String> translation, Resource resource, Session session) {
        Node commentNode = resource.adaptTo(Node.class);
        try {
            if (!commentNode.hasNode(TRANSLATION_NODE_NAME)) {
                commentNode.addNode(TRANSLATION_NODE_NAME);
            }
        }
        catch (RepositoryException e) {
            LOG.error("Unable to add translation node", (Throwable)e);
        }
        try {
            VersionManager versionManager = null;
            if (session != null) {
                versionManager = session.getWorkspace().getVersionManager();
            }
            Node transLan = null;
            String path = "";
            if (!commentNode.getNode(TRANSLATION_NODE_NAME).hasNode(toLan)) {
                transLan = commentNode.getNode(TRANSLATION_NODE_NAME).addNode(toLan);
                transLan.addMixin("mix:versionable");
                path = transLan.getPath();
            } else {
                transLan = commentNode.getNode(TRANSLATION_NODE_NAME).getNode(toLan);
                path = transLan.getPath();
                if (versionManager != null) {
                    versionManager.checkout(path);
                }
            }
            for (String s : translation.keySet()) {
                transLan.setProperty(s, translation.get(s));
            }
            Calendar today = Calendar.getInstance();
            transLan.setProperty(TRANSLATION_DATE_PROP, today);
            transLan.setProperty(POST_EDITED_PROP, false);
            commentNode.setProperty(TRANSLATION_DATE_PROP, (Calendar)new GregorianCalendar());
            if (session != null && versionManager != null) {
                session.save();
                versionManager.checkin(path);
            }
        }
        catch (RepositoryException e) {
            LOG.error("Unable to get the results", (Throwable)e);
        }
    }

    public static void translateOnSave(String fromLan, String toLan, Resource resource, Session session, TranslationManager tm, String[] properties) {
        LOG.debug("Resource path: {}", (Object)resource.getPath());
        TranslationResults translation = TranslationUtil.getTranslation(fromLan, toLan, properties, resource, tm);
        if ("Success".equals(translation.getStatus())) {
            TranslationUtil.saveTranslation(toLan, translation.getTranslation(), resource, session);
        }
    }

    public static TranslationUpdate getTranslationUpdate(String fromLan, String toLan, Resource resource, TranslationManager tm, String[] properties) {
        TranslationResults translation = TranslationUtil.getTranslation(fromLan, toLan, properties, resource, tm);
        if ("Success".equals(translation.getStatus())) {
            return new TranslationUpdate(resource.getPath(), toLan, translation.getTranslation());
        }
        return null;
    }

    public static TranslationResults getTranslation(String fromLan, String toLan, String[] properties, Resource resource, TranslationManager tm) {
        TranslationResults result = null;
        if (TranslationUtil.languagesAreEquivalent(fromLan, toLan).booleanValue()) {
            LOG.trace("From language was the same as to Language, returnin gnull TranslatioNResults", (Object)toLan);
            return null;
        }
        String resultStatus = "";
        boolean hasSuccess = false;
        boolean failed = false;
        HashMap<String, String> propertiesThatExistOnResource = new HashMap<String, String>();
        ValueMap resourceValueMap = resource.adaptTo(ValueMap.class);
        for (String property : properties) {
            String tempValue = resourceValueMap.get(property, "");
            if (tempValue.isEmpty()) continue;
            propertiesThatExistOnResource.put(property, tempValue);
        }
        HashMap<String, String> translated = new HashMap<String, String>();
        Set entrySet = propertiesThatExistOnResource.entrySet();
        if (entrySet.size() > 0) {
            for (Map.Entry thisEntry : entrySet) {
                int tried = 0;
                String property = (String)thisEntry.getKey();
                TranslationResult translationResult = null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("property: {}", (Object)property);
                }
                String temp = (String)thisEntry.getValue();
                while (tried < TranslationVariables.getRetry() && translationResult == null) {
                    translationResult = TranslationUtil.getTranslation(fromLan, toLan, temp, resource, tm);
                    ++tried;
                }
                if (translationResult != null) {
                    translated.put(property, translationResult.getTranslation());
                    hasSuccess = true;
                    continue;
                }
                translated.put(property, temp);
                failed = true;
            }
            if (hasSuccess && failed) {
                resultStatus = "Partial Success";
            }
            if (hasSuccess && !failed) {
                resultStatus = "Success";
            }
            if (!hasSuccess) {
                resultStatus = "Fail";
            }
        } else {
            resultStatus = "Not processing empty properties / keySet";
        }
        String attribution = null;
        try {
            attribution = tm.createTranslationService(resource).getTranslationServiceInfo().getTranslationServiceAttribution();
        }
        catch (Exception e) {
            LOG.trace("error getting attribution ", (Throwable)e);
        }
        result = new TranslationResults(resultStatus, translated, attribution);
        return result;
    }

    public static Boolean languagesAreEquivalent(String fromLan, String toLan) {
        if (fromLan == null || toLan == null) {
            return false;
        }
        int fromLength = fromLan.length();
        int toLength = toLan.length();
        if (fromLength < 2 || toLength < 2) {
            return false;
        }
        if (fromLength == toLength) {
            return StringUtils.equalsIgnoreCase((String)fromLan, (String)toLan);
        }
        return StringUtils.equalsIgnoreCase((String)fromLan.substring(0, 2), (String)toLan.substring(0, 2));
    }
}

