/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.translation;

import java.util.HashMap;
import java.util.Map;

public class LanguageCodeMap {
    private static final Map<String, String> HM = new HashMap<String, String>();
    private static final Map<String, String> SPECIAL_CODES = new HashMap<String, String>();

    public static boolean sameLanguageCode(String languageCode1, String languageCode2) {
        if (languageCode1.equals(languageCode2)) {
            return true;
        }
        if (languageCode1.substring(0, 2).equals(languageCode2.substring(0, 2)) && !"zh".equals(languageCode1.substring(0, 2))) {
            return true;
        }
        return SPECIAL_CODES.containsKey(languageCode1) && SPECIAL_CODES.get(languageCode1).toString().equals(languageCode2) || SPECIAL_CODES.containsKey(languageCode2) && SPECIAL_CODES.get(languageCode2).toString().equals(languageCode1);
    }

    public static String getCLSMTLanguageCode(String languageCode) {
        if (HM.containsKey(languageCode)) {
            return languageCode;
        }
        if (SPECIAL_CODES.containsKey(languageCode)) {
            return SPECIAL_CODES.get(languageCode).toString();
        }
        for (String key : HM.keySet()) {
            if (!key.substring(0, 2).equals(languageCode.substring(0, 2))) continue;
            return key;
        }
        return null;
    }

    public static String getLanguage(String languageCode) {
        return HM.get(languageCode);
    }

    static {
        HM.put("ar_AE", "Arabic");
        HM.put("bg", "Bulgarian");
        HM.put("zh_CN", "Simplified Chinese");
        HM.put("cs_ZH", "Traditional Chinese");
        HM.put("cs_CZ", "Czech");
        HM.put("da", "Danish");
        HM.put("nl_NL", "Dutch");
        HM.put("en_US", "English");
        HM.put("et", "Estonian");
        HM.put("fi_FI", "Finnish");
        HM.put("fr_FR", "French");
        HM.put("de_DE", "German");
        HM.put("el_GR", "Greek");
        HM.put("ht", "Haitian Creole");
        HM.put("he", "Hebrew");
        HM.put("hu", "Hungarian");
        HM.put("id", "Indonesian");
        HM.put("it_IT", "Italian");
        HM.put("ja_JP", "Japanese");
        HM.put("ko_KR", "Korean");
        HM.put("lv", "Latvian");
        HM.put("no_NO", "Norwegian");
        HM.put("pl_PL", "Polish");
        HM.put("pt_BR", "Portuguese");
        HM.put("ro_RO", "Romanian");
        HM.put("ru_RU", "Russian");
        HM.put("sk", "Slovak");
        HM.put("sl", "Slovenian");
        HM.put("es_ES", "Spanish");
        HM.put("sv_SE", "Swedish");
        HM.put("th", "Thai");
        HM.put("tr_TR", "Turkish");
        HM.put("uk", "Ukrainian");
        HM.put("vi", "Vietnamese");
        SPECIAL_CODES.put("zh-cn", "zh_CN");
        SPECIAL_CODES.put("zh-tw", "cs_ZH");
    }
}

