/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.tally.Response;
import com.adobe.cq.social.tally.TallyException;
import com.adobe.cq.social.tally.Vote;
import com.adobe.cq.social.tally.Voting;
import com.adobe.cq.social.tally.client.api.AbstractTally;
import com.adobe.cq.social.tally.client.api.VotingSocialComponent;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

public class AbstractVoting
extends AbstractTally
implements VotingSocialComponent {
    private final Voting votingComponent;

    public AbstractVoting(Resource resource) {
        this(resource.adaptTo(Voting.class), null);
    }

    public AbstractVoting(Resource resource, ClientUtilities clientUtils) {
        this(resource.adaptTo(Voting.class), clientUtils);
    }

    public AbstractVoting(Voting votingComponent, ClientUtilities clientUtils) {
        super(votingComponent, clientUtils);
        this.votingComponent = votingComponent;
    }

    @Override
    public long getNetCount() {
        return this.votingComponent.getPositiveCount() - this.votingComponent.getNegativeCount();
    }

    @Override
    public long getPositiveCount() {
        return this.votingComponent.getPositiveCount();
    }

    @Override
    public long getNegativeCount() {
        return this.votingComponent.getNegativeCount();
    }

    @Override
    public String getPositiveLabel() {
        return this.votingComponent.getPositiveLabel();
    }

    @Override
    public String getNegativeLabel() {
        return this.votingComponent.getNegativeLabel();
    }

    @Override
    public boolean isCurrentUserLike() {
        try {
            Response resp = this.votingComponent.getUserResponse(this.currentUser);
            if (resp == null) {
                return false;
            }
            return Vote.LIKE.equals(resp.getResponseValue());
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (TallyException e) {
            return false;
        }
    }

    protected Voting getVotingComponent() {
        return this.votingComponent;
    }
}

