/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.commons.client.api.BaseSocialComponent;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.tally.Poll;
import com.adobe.cq.social.tally.Response;
import com.adobe.cq.social.tally.ResponseValue;
import com.adobe.cq.social.tally.Tally;
import com.adobe.cq.social.tally.TallyException;
import com.adobe.cq.social.tally.Voting;
import com.adobe.cq.social.tally.client.api.TallySocialComponent;
import com.adobe.granite.security.user.UserProperties;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class AbstractTally
extends BaseSocialComponent
implements TallySocialComponent {
    private final Resource resource;
    private final Tally<?> tally;
    protected final String currentUser;

    public AbstractTally(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.resource = resource;
        ResourceResolver resolver = this.resource.getResourceResolver();
        this.tally = resolver.isResourceType(this.resource, "social/tally/components/poll") ? (Tally)resource.adaptTo(Poll.class) : (resolver.isResourceType(this.resource, "social/tally/components/voting") ? (Tally)resource.adaptTo(Voting.class) : null);
        this.currentUser = resolver.getUserID();
    }

    public AbstractTally(Tally tally, ClientUtilities clientUtils) {
        super(tally.getTallyTarget(), clientUtils);
        this.resource = tally.getTallyTarget();
        this.tally = tally;
        UserProperties loggedInUserProperties = this.resource.getResourceResolver().adaptTo(UserProperties.class);
        this.currentUser = loggedInUserProperties != null ? loggedInUserProperties.getAuthorizableID() : null;
    }

    @Override
    public String getName() {
        return this.tally.getName();
    }

    @Override
    public Long getTotalNumberOfResponses() {
        return this.tally.getTotalNumberOfResponses();
    }

    @Override
    public ResponseValue getCurrentUserResponse() throws TallyException {
        try {
            Response<?> resp = this.tally.getUserResponse(this.currentUser);
            if (resp == null) {
                return null;
            }
            return resp.getResponseValue();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public Map<String, Long> getResponseTallies() {
        HashMap<String, Long> local = new HashMap<String, Long>();
        Map<?, Long> responses = this.tally.getResponseTallies();
        for (Map.Entry<?, Long> entry : responses.entrySet()) {
            local.put(((ResponseValue)entry.getKey()).getResponseValue(), entry.getValue());
        }
        return local;
    }

    public void addResponse(String value) {
        try {
            this.tally.setUserResponse(this.currentUser, value);
        }
        catch (TallyException e) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void removeCurrentUserResponse() {
        try {
            this.tally.unsetUserResponse(this.currentUser);
        }
        catch (TallyException e) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public boolean getCanUserRespond() {
        return this.tally.canUserRespond();
    }

    protected Tally<?> getTally() {
        return this.tally;
    }
}

