/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.index;

import com.adobe.cq.social.storage.index.IndexElement;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;

public class BaseIndexElement
implements IndexElement {
    private final Resource resource;
    private final Map<String, Object> properties;

    public BaseIndexElement(Resource resource) {
        this.resource = resource;
        this.properties = new HashMap<String, Object>();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        return this.convert(this.properties.get(name), type);
    }

    @Override
    public void put(String name, Object value) {
        this.properties.put(name, value);
    }

    private <T> T convert(Object obj, Class<T> type) {
        try {
            if (obj == null) {
                return null;
            }
            if (type.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            if (type.isArray()) {
                return (T)this.convertToArray(obj, type.getComponentType());
            }
            if (type == String.class) {
                return (T)String.valueOf(obj);
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(obj.toString()));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(Long.parseLong(obj.toString()));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(Double.parseDouble(obj.toString()));
            }
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(obj.toString()));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private <T> T[] convertToArray(Object obj, Class<T> type) {
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            Object[] result = (Object[])Array.newInstance(type, array.length);
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convert(array[i], type);
            }
            return result;
        }
        Object[] result = (Object[])Array.newInstance(type, 1);
        result[0] = this.convert(obj, type);
        return result;
    }
}

