/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.index;

import com.adobe.cq.social.storage.buckets.NestedBucketStorageSystem;
import com.adobe.cq.social.storage.index.Index;
import com.adobe.cq.social.storage.index.IndexCounter;
import com.adobe.cq.social.storage.index.IndexElementFactory;
import com.adobe.cq.social.storage.index.IndexServiceException;
import com.adobe.cq.social.storage.index.IndexUtil;
import com.adobe.cq.social.storage.index.Indexer;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseIndexer<K, E>
implements Indexer<K, E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseIndexer.class);
    protected String rootIndexResourcePath;
    private static final int MAX_BUCKET_INDEX_SIZE = 1000;
    private static final String BUCKET_RESOURCE_TYPE = "sling:OrderedFolder";
    public static final int KEY_INDEX = 0;
    private final Comparator<K> comparator;
    private static final Random random = new Random();
    private final boolean writeMode;
    private final String indexPath;
    private final String ugcBasePath;

    public AbstractBaseIndexer(ResourceResolver resolver, String basePath, String indexPath, Comparator<K> comparator, boolean writeMode) throws RepositoryException {
        this.comparator = comparator;
        int ugcIndex = basePath.indexOf("/content/usergenerated");
        if (basePath.indexOf("/content/usergenerated") != -1) {
            basePath = basePath.substring(ugcIndex + "/content/usergenerated".length());
        }
        this.ugcBasePath = writeMode ? IndexUtil.prepareUserGeneratedContent(resolver, basePath) : "/content/usergenerated" + basePath;
        StringBuilder path = new StringBuilder(this.ugcBasePath);
        if (!path.toString().endsWith("/")) {
            path.append("/");
        }
        path.append(indexPath);
        this.rootIndexResourcePath = path.toString();
        this.writeMode = writeMode;
        this.indexPath = indexPath;
    }

    private Resource getRootIndexResource(ResourceResolver resolver) {
        Resource rootIndexResource = resolver.getResource(this.rootIndexResourcePath);
        if (this.writeMode) {
            Session session = resolver.adaptTo(Session.class);
            if (session == null) {
                throw new IllegalArgumentException("resolver must be adaptable to session");
            }
            if (rootIndexResource == null) {
                Resource resource = resolver.getResource(this.ugcBasePath);
                if (resource != null) {
                    Node ugcBase = resource.adaptTo(Node.class);
                    try {
                        Node indexBase = JcrUtil.createPath(ugcBase, this.indexPath, false, "sling:Folder", BUCKET_RESOURCE_TYPE, session, false);
                        JcrUtil.createPath(indexBase, "counter", false, "nt:unstructured", "nt:unstructured", session, false);
                    }
                    catch (RepositoryException e) {
                        log.error("Error creating index " + this.indexPath, (Throwable)e);
                        return null;
                    }
                    try {
                        session.save();
                    }
                    catch (RepositoryException re) {
                        throw new IndexServiceException("failed to save changes", (Exception)((Object)re));
                    }
                    rootIndexResource = resolver.getResource(this.rootIndexResourcePath);
                } else {
                    throw new IndexServiceException("Failed to resolve " + this.ugcBasePath);
                }
            }
        }
        return rootIndexResource;
    }

    protected IndexCounter getCounter(ResourceResolver resolver) {
        Resource resource = resolver.getResource(this.rootIndexResourcePath + "/" + "counter");
        return resource == null ? null : resource.adaptTo(IndexCounter.class);
    }

    @Override
    public long getSize(ResourceResolver resolver) {
        IndexCounter counter = this.getCounter(resolver);
        return counter == null ? 0L : counter.getTotalCount();
    }

    private NestedBucketStorageSystem getStorageSystem(ResourceResolver resolver) {
        return this.getStorageSystem(this.getRootIndexResource(resolver));
    }

    private NestedBucketStorageSystem getStorageSystem(Resource root) {
        NestedBucketStorageSystem storageSystem;
        NestedBucketStorageSystem nestedBucketStorageSystem = storageSystem = root == null ? null : root.adaptTo(NestedBucketStorageSystem.class);
        if (storageSystem != null) {
            storageSystem.setBucketResourceType(BUCKET_RESOURCE_TYPE);
        }
        return storageSystem;
    }

    private List<Resource> getIndexBuckets(ResourceResolver resolver, Resource indexResource) {
        ArrayList<Resource> indicies = new ArrayList<Resource>();
        if (indexResource == null) {
            return indicies;
        }
        NestedBucketStorageSystem storageSystem = this.getStorageSystem(resolver);
        Iterator<Resource> iter = storageSystem.listChildren();
        while (iter.hasNext()) {
            Resource r = iter.next();
            if (r.getName().equals("counter") || r.getName().equals("key")) continue;
            indicies.add(r);
        }
        return indicies;
    }

    private int[] createIndexBucket(String newNodeName, int numBuckets, int[] counters, String index, Resource rootIndexResource, Session session) throws RepositoryException {
        NestedBucketStorageSystem storageSystem = this.getStorageSystem(rootIndexResource);
        Resource targetResource = storageSystem.addResource(JcrUtil.createValidName(String.valueOf(newNodeName)), "nt:unstructured");
        Node targetNode = targetResource.adaptTo(Node.class);
        String[] indices = new String[]{index};
        targetNode.setProperty("indices", indices);
        int[] newCounters = new int[numBuckets + 1];
        System.arraycopy(counters, 0, newCounters, 0, counters.length);
        newCounters[newCounters.length - 1] = 1;
        return newCounters;
    }

    private void addIndex(int indexLoc, int[] counters, K targetKey, String index, Session session, Resource indexBucketResource, Index targetIndex) throws RepositoryException {
        String currentKey;
        int i;
        Object[] indices = targetIndex.getIndices();
        String[] newIndices = new String[indices.length + 1];
        for (i = 0; i < indices.length && this.comparator.compare(this.stringToK(currentKey = indices[i].toString().split(",")[0]), targetKey) < 0; ++i) {
            newIndices[i] = indices[i].toString();
        }
        newIndices[i] = index;
        while (i < indices.length) {
            newIndices[i + 1] = indices[i].toString();
            ++i;
        }
        Node targetNode = indexBucketResource.adaptTo(Node.class);
        targetNode.setProperty("indices", newIndices);
        counters[indexLoc] = newIndices.length;
    }

    private String getNewSplitIndexName(String prevIndexName, String targetIndexName) {
        long start;
        String startPre;
        if (prevIndexName == null) {
            startPre = "0";
            start = 0L;
        } else {
            int cut1 = prevIndexName.indexOf("_");
            startPre = cut1 == -1 ? prevIndexName : prevIndexName.substring(0, cut1);
            start = cut1 == -1 ? 0L : Long.parseLong(prevIndexName.substring(cut1 + 1));
        }
        int cut2 = targetIndexName.indexOf("_");
        int rand = Math.abs(random.nextInt());
        if (cut2 == -1) {
            return startPre + "_" + ((long)rand + start + 1L);
        }
        long end = Long.parseLong(targetIndexName.substring(cut2 + 1));
        return startPre + "_" + ((long)rand % (end - 1L - (start + 1L)) + (start + 1L));
    }

    private int[] splitIndex(String prevIndexName, int targetIndexLoc, int[] counters, K targetKey, String index, Resource rootIndexResource, Session session, Resource targetResource, Index targetIndex) throws RepositoryException {
        String[] indices2;
        String[] indices1;
        Object[] indices = targetIndex.getIndices();
        String midKey = indices[indices.length / 2].toString().split(",")[0];
        if (this.comparator.compare(this.stringToK(midKey), targetKey) > 0) {
            indices1 = new String[1 + indices.length / 2];
            indices2 = new String[indices.length / 2];
        } else {
            indices1 = new String[indices.length / 2];
            indices2 = new String[1 + indices.length / 2];
        }
        String[] currentIndices = indices1;
        boolean insertedTarget = false;
        int j = 0;
        for (int i = 0; i < indices.length; ++i) {
            Object currentKey = this.stringToK(indices[i].toString().split(",")[0]);
            if (this.comparator.compare(targetKey, currentKey) < 0 && !insertedTarget) {
                currentIndices[j] = index;
                insertedTarget = true;
                if (++j == currentIndices.length) {
                    currentIndices = indices2;
                    j = 0;
                }
            }
            currentIndices[j] = indices[i];
            if (++j != currentIndices.length) continue;
            currentIndices = indices2;
            j = 0;
        }
        Node targetNode = targetResource.adaptTo(Node.class);
        targetNode.setProperty("indices", indices2);
        String newNodeName = this.getNewSplitIndexName(prevIndexName, targetNode.getName());
        Node parentNode = targetResource.getParent().adaptTo(Node.class);
        Node newNode = JcrUtil.createUniqueNode(parentNode, JcrUtil.createValidName(newNodeName), "nt:unstructured", session);
        newNode.setProperty("indices", indices1);
        parentNode.orderBefore(newNode.getName(), targetResource.getName());
        int[] newCounters = new int[counters.length + 1];
        System.arraycopy(counters, 0, newCounters, 0, targetIndexLoc);
        newCounters[targetIndexLoc] = indices1.length;
        newCounters[targetIndexLoc + 1] = indices2.length;
        System.arraycopy(counters, targetIndexLoc + 1, newCounters, targetIndexLoc + 2, counters.length - targetIndexLoc - 1);
        return newCounters;
    }

    private String getNextNodeName(List<Resource> indexNodes) {
        int size = indexNodes.size();
        if (size == 0) {
            return "1";
        }
        char[] prevName = indexNodes.get(size - 1).getName().toCharArray();
        StringBuffer prevNum = new StringBuffer();
        for (int i = 0; i < prevName.length && Character.isDigit(prevName[i]); ++i) {
            prevNum.append(prevName[i]);
        }
        return String.valueOf(Integer.parseInt(prevNum.toString()) + 1);
    }

    @Override
    public String index(ResourceResolver resolver, E target, K indexKey, String indexContent) throws RepositoryException {
        Index targetIndex;
        Session session = resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("resolver must be adaptable to session");
        }
        Resource rootIndexResource = this.getRootIndexResource(resolver);
        List<Resource> indexNodes = this.getIndexBuckets(resolver, rootIndexResource);
        Node counterNode = resolver.getResource(rootIndexResource.getPath() + "/" + "counter").adaptTo(Node.class);
        IndexCounter counter = this.getCounter(resolver);
        int[] counters = counter.getCounters();
        String index = indexKey + "," + indexContent;
        int indexLoc = this.findIndexBucket(indexNodes, indexKey);
        Resource targetIndexResource = indexLoc == -1 ? null : indexNodes.get(indexLoc);
        Index index2 = targetIndex = indexLoc == -1 ? null : targetIndexResource.adaptTo(Index.class);
        if (indexLoc == -1) {
            counters = this.createIndexBucket(this.getNextNodeName(indexNodes), indexNodes.size(), counters, index, rootIndexResource, session);
        } else if (targetIndex.getIndices().length < 1000) {
            this.addIndex(indexLoc, counters, indexKey, index, session, targetIndexResource, targetIndex);
        } else {
            counters = this.splitIndex(indexLoc == 0 ? null : indexNodes.get(indexLoc - 1).getName(), indexLoc, counters, indexKey, index, rootIndexResource, session, targetIndexResource, targetIndex);
        }
        String[] counterStrs = new String[counters.length];
        for (int i = 0; i < counterStrs.length; ++i) {
            counterStrs[i] = String.valueOf(counters[i]);
        }
        counterNode.setProperty("counters", counterStrs);
        counterNode.setProperty("totalCount", counter.getTotalCount() + 1L);
        return indexKey.toString();
    }

    @Override
    public String getIndex(ResourceResolver resolver, K key, String endsWith) {
        Resource rootIndexResource = this.getRootIndexResource(resolver);
        List<Resource> indexNodes = this.getIndexBuckets(resolver, rootIndexResource);
        int indexNodeLoc = this.findIndexBucket(indexNodes, key);
        if (indexNodeLoc == -1) {
            return null;
        }
        FindIndexWrapper resp = this.findIndex(indexNodes, indexNodeLoc, key, endsWith);
        if (resp == null) {
            return null;
        }
        return resp.index;
    }

    private FindBucketAndLocWrapper findBucketAndLoc(ResourceResolver resolver, K key, String endsWith) {
        Resource rootIndexResource = this.getRootIndexResource(resolver);
        List<Resource> indexNodes = this.getIndexBuckets(resolver, rootIndexResource);
        int bucketLoc = this.findIndexBucket(indexNodes, key);
        if (bucketLoc == -1) {
            return null;
        }
        FindIndexWrapper resp = this.findIndex(indexNodes, bucketLoc, key, endsWith);
        if (resp == null) {
            return null;
        }
        return new FindBucketAndLocWrapper(bucketLoc, resp.indexLoc);
    }

    public int getIndexLocForwards(ResourceResolver resolver, K key, String endsWith) {
        FindBucketAndLocWrapper resp = this.findBucketAndLoc(resolver, key, endsWith);
        if (resp == null) {
            return -1;
        }
        int[] counter = this.getCounter(resolver).getCounters();
        int total = 0;
        for (int i = 0; i < resp.bucketLoc; ++i) {
            total += counter[i];
        }
        return total + resp.indexLoc;
    }

    public int getIndexLocBackwards(ResourceResolver resolver, K key, String endsWith) {
        FindBucketAndLocWrapper resp = this.findBucketAndLoc(resolver, key, endsWith);
        if (resp == null) {
            return -1;
        }
        int[] counter = this.getCounter(resolver).getCounters();
        int total = 0;
        for (int i = counter.length - 1; i > resp.bucketLoc; --i) {
            total += counter[i];
        }
        return total + (counter[resp.bucketLoc] - resp.indexLoc - 1);
    }

    @Override
    public String reindex(ResourceResolver resolver, E target, K oldIndexKey, K indexKey, String indexContent, boolean force, String endsWith) throws RepositoryException {
        this.unindex(resolver, oldIndexKey, endsWith);
        this.index(resolver, target, indexKey, indexContent);
        return null;
    }

    private int findIndexBucket(List<Resource> indexBuckets, K targetKey) {
        if (indexBuckets.size() == 0) {
            return -1;
        }
        int start = 0;
        int end = indexBuckets.size() - 1;
        int m = (start + end) / 2;
        while (start <= end) {
            Index targetIndex = indexBuckets.get(m).adaptTo(Index.class);
            Object[] indices = targetIndex.getIndices();
            if (indices.length == 0) {
                return m;
            }
            Object midStartKey = this.stringToK(indices[0].toString().split(",")[0]);
            Object midEndKey = this.stringToK(indices[indices.length - 1].toString().split(",")[0]);
            if (this.comparator.compare(targetKey, midStartKey) >= 0 && this.comparator.compare(targetKey, midEndKey) <= 0) {
                return m;
            }
            if (start == end || m == 0 && this.comparator.compare(targetKey, midStartKey) <= 0 || m == indexBuckets.size() - 1 && this.comparator.compare(targetKey, midEndKey) >= 0) {
                Index rightIndex;
                if (indices.length < 1000) {
                    return m;
                }
                Index leftIndex = m - 1 >= 0 ? indexBuckets.get(m - 1).adaptTo(Index.class) : null;
                Index index = rightIndex = m + 1 < indexBuckets.size() ? indexBuckets.get(m + 1).adaptTo(Index.class) : null;
                if (this.comparator.compare(targetKey, midEndKey) >= 0 && rightIndex == null) {
                    return -1;
                }
                if (this.comparator.compare(targetKey, midEndKey) >= 0 && rightIndex.getIndices().length < 1000) {
                    return m + 1;
                }
                if (this.comparator.compare(targetKey, midStartKey) <= 0 && leftIndex != null && leftIndex.getIndices().length < 1000) {
                    return m - 1;
                }
                return m;
            }
            if (this.comparator.compare(targetKey, midStartKey) < 0) {
                end = m - 1;
            } else {
                start = m + 1;
            }
            m = (start + end) / 2;
        }
        return m;
    }

    public FindIndexWrapper findIndex(List<Resource> indexNodes, int indexNodeLoc, K targetKey, String endsWith) {
        Resource r = indexNodes.get(indexNodeLoc);
        Index targetIndex = r.adaptTo(Index.class);
        Object[] indices = targetIndex.getIndices();
        int start = 0;
        int end = indices.length - 1;
        int m = (start + end) / 2;
        while (start <= end) {
            String index = indices[m].toString();
            Object midKey = this.stringToK(index.split(",")[0]);
            if (this.comparator.compare(targetKey, midKey) == 0) {
                Object currentKey;
                int currentBucket;
                if (endsWith == null || index.endsWith(endsWith)) {
                    return new FindIndexWrapper(m, r, index);
                }
                int currentLoc = m - 1;
                block1: for (currentBucket = indexNodeLoc; currentBucket >= 0; --currentBucket) {
                    r = indexNodes.get(indexNodeLoc);
                    targetIndex = r.adaptTo(Index.class);
                    indices = targetIndex.getIndices();
                    while (currentLoc >= 0) {
                        index = indices[currentLoc].toString();
                        currentKey = this.stringToK(index.split(",")[0]);
                        if (this.comparator.compare(targetKey, currentKey) != 0) {
                            currentBucket = 0;
                            continue block1;
                        }
                        if (index.endsWith(endsWith)) {
                            return new FindIndexWrapper(currentLoc, r, index);
                        }
                        --currentLoc;
                    }
                }
                currentLoc = m + 1;
                for (currentBucket = indexNodeLoc; currentBucket < indexNodes.size(); ++currentBucket) {
                    r = indexNodes.get(indexNodeLoc);
                    targetIndex = r.adaptTo(Index.class);
                    indices = targetIndex.getIndices();
                    while (currentLoc < indices.length) {
                        index = indices[currentLoc].toString();
                        currentKey = this.stringToK(index.split(",")[0]);
                        if (this.comparator.compare(targetKey, currentKey) != 0) {
                            return null;
                        }
                        if (index.endsWith(endsWith)) {
                            return new FindIndexWrapper(currentLoc, r, index);
                        }
                        ++currentLoc;
                    }
                }
                return null;
            }
            if (this.comparator.compare(targetKey, midKey) < 0) {
                end = m - 1;
            } else {
                start = m + 1;
            }
            m = (start + end) / 2;
        }
        return null;
    }

    @Override
    public void unindex(ResourceResolver resolver, K indexKey, String endsWith) throws RepositoryException {
        Resource rootIndexResource = this.getRootIndexResource(resolver);
        List<Resource> indexNodes = this.getIndexBuckets(resolver, rootIndexResource);
        int indexNodeLoc = this.findIndexBucket(indexNodes, indexKey);
        if (indexNodeLoc == -1) {
            return;
        }
        FindIndexWrapper resp = this.findIndex(indexNodes, indexNodeLoc, indexKey, endsWith);
        if (resp == null) {
            return;
        }
        int indexLoc = resp.indexLoc;
        Node targetNode = resp.indexResource.adaptTo(Node.class);
        Index targetIndex = resp.indexResource.adaptTo(Index.class);
        Object[] indices = targetIndex.getIndices();
        IndexCounter counter = this.getCounter(resolver);
        int[] counters = counter.getCounters();
        int n = indexNodeLoc;
        counters[n] = counters[n] - 1;
        if (counters[indexNodeLoc] == 0) {
            targetNode.remove();
        } else {
            String[] newIndices = new String[indices.length - 1];
            System.arraycopy(indices, 0, newIndices, 0, indexLoc);
            if (indexLoc != indices.length - 1) {
                System.arraycopy(indices, indexLoc + 1, newIndices, indexLoc, indices.length - indexLoc - 1);
            }
            targetNode.setProperty("indices", newIndices);
        }
        Node counterNode = resolver.getResource(rootIndexResource.getPath() + "/" + "counter").adaptTo(Node.class);
        String[] counterStrs = new String[counters[indexNodeLoc] == 0 ? counters.length - 1 : counters.length];
        int counterStrsIndex = 0;
        for (int i = 0; i < counters.length; ++i) {
            if (i == indexNodeLoc && counters[indexNodeLoc] == 0) continue;
            counterStrs[counterStrsIndex] = String.valueOf(counters[i]);
            ++counterStrsIndex;
        }
        counterNode.setProperty("counters", counterStrs);
        counterNode.setProperty("totalCount", counter.getTotalCount() - 1L);
    }

    protected List<E> getElementsBackwards(ResourceResolver resolver, int start, int size, String elementRootPath) {
        if (start < 0) {
            return new LinkedList();
        }
        Resource rootIndexResource = this.getRootIndexResource(resolver);
        LinkedList<E> results = new LinkedList<E>();
        if (rootIndexResource == null) {
            return results;
        }
        List<Resource> indicies = this.getIndexBuckets(resolver, rootIndexResource);
        IndexCounter counter = this.getCounter(resolver);
        long sizeLeft = counter.getTotalCount();
        int[] counters = counter.getCounters();
        int currentBucket = indicies.size() - 1;
        while (sizeLeft - (long)counters[currentBucket] > (long)start) {
            sizeLeft -= (long)counters[currentBucket];
            --currentBucket;
        }
        int currentIndex = (int)((long)start - (sizeLeft -= (long)counters[currentBucket]));
        while (results.size() < size && currentBucket >= 0) {
            Index index = indicies.get(currentBucket).adaptTo(Index.class);
            Object[] indices = index.getIndices();
            if (currentIndex >= indices.length) {
                log.error("Counter error for " + elementRootPath + " at " + currentBucket + ". CurrentIndex " + currentIndex + " is out of bounds.  Max index is " + (indices.length - 1));
                currentIndex = indices.length - 1;
            }
            while (results.size() < size && currentIndex >= 0) {
                E element = this.getElementFromIndex(resolver, elementRootPath, indices[currentIndex].toString());
                if (element != null) {
                    results.add(element);
                }
                --currentIndex;
            }
            if (--currentBucket < 0) continue;
            currentIndex = counters[currentBucket] - 1;
        }
        return results;
    }

    protected <C> List<C> getComponentElementsBackwards(ResourceResolver resolver, int start, int size, String elementRootPath, IndexElementFactory<C> resourceElementFactory) {
        LinkedList<C> results = new LinkedList<C>();
        if (start < 0) {
            return results;
        }
        Resource rootIndexResource = this.getRootIndexResource(resolver);
        if (rootIndexResource == null) {
            return results;
        }
        List<Resource> indicies = this.getIndexBuckets(resolver, rootIndexResource);
        IndexCounter counter = this.getCounter(resolver);
        long sizeLeft = counter.getTotalCount();
        int[] counters = counter.getCounters();
        int currentBucket = indicies.size() - 1;
        while (sizeLeft - (long)counters[currentBucket] > (long)start) {
            sizeLeft -= (long)counters[currentBucket];
            --currentBucket;
        }
        int currentIndex = (int)((long)start - (sizeLeft -= (long)counters[currentBucket]));
        while (results.size() < size && currentBucket >= 0) {
            Index index = indicies.get(currentBucket).adaptTo(Index.class);
            Object[] indices = index.getIndices();
            if (currentIndex >= indices.length) {
                log.error("Counter error for " + elementRootPath + " at " + currentBucket + ". CurrentIndex " + currentIndex + " is out of bounds.  Max index is " + (indices.length - 1));
                currentIndex = indices.length - 1;
            }
            while (results.size() < size && currentIndex >= 0) {
                C element = this.getComponentElementFromIndex(resolver, elementRootPath, indices[currentIndex].toString(), resourceElementFactory);
                if (element != null) {
                    results.add(element);
                }
                --currentIndex;
            }
            if (--currentBucket < 0) continue;
            currentIndex = counters[currentBucket] - 1;
        }
        return results;
    }

    protected List<E> getElementsForwards(ResourceResolver resolver, int start, int size, String elementRootPath) {
        if (start < 0) {
            return new LinkedList();
        }
        Resource rootIndexResource = this.getRootIndexResource(resolver);
        LinkedList<E> results = new LinkedList<E>();
        if (rootIndexResource == null) {
            return results;
        }
        List<Resource> indicies = this.getIndexBuckets(resolver, rootIndexResource);
        IndexCounter counter = this.getCounter(resolver);
        long total = counter.getTotalCount();
        int[] counters = counter.getCounters();
        int currentBucket = 0;
        start = (int)total - start - 1;
        int totalPrev = 0;
        while (totalPrev + counters[currentBucket] < start) {
            totalPrev += counters[currentBucket];
            ++currentBucket;
        }
        int currentIndex = start - totalPrev;
        while (results.size() < size && currentBucket < indicies.size()) {
            Index index = indicies.get(currentBucket).adaptTo(Index.class);
            Object[] indices = index.getIndices();
            while (results.size() < size && currentIndex < indices.length) {
                E element = this.getElementFromIndex(resolver, elementRootPath, indices[currentIndex].toString());
                if (element != null) {
                    results.add(element);
                }
                ++currentIndex;
            }
            ++currentBucket;
            currentIndex = 0;
        }
        return results;
    }

    protected <C> List<C> getComponentElementsForwards(ResourceResolver resolver, int start, int size, String elementRootPath, IndexElementFactory<C> resourceElementFactory) {
        if (start < 0) {
            return new LinkedList();
        }
        Resource rootIndexResource = this.getRootIndexResource(resolver);
        LinkedList<C> results = new LinkedList<C>();
        if (rootIndexResource == null) {
            return results;
        }
        List<Resource> indicies = this.getIndexBuckets(resolver, rootIndexResource);
        IndexCounter counter = this.getCounter(resolver);
        long total = counter.getTotalCount();
        int[] counters = counter.getCounters();
        int currentBucket = 0;
        start = (int)total - start - 1;
        int totalPrev = 0;
        while (totalPrev + counters[currentBucket] < start) {
            totalPrev += counters[currentBucket];
            ++currentBucket;
        }
        int currentIndex = start - totalPrev;
        while (results.size() < size && currentBucket < indicies.size()) {
            Index index = indicies.get(currentBucket).adaptTo(Index.class);
            Object[] indices = index.getIndices();
            while (results.size() < size && currentIndex < indices.length) {
                C element = this.getComponentElementFromIndex(resolver, elementRootPath, indices[currentIndex].toString(), resourceElementFactory);
                if (element != null) {
                    results.add(element);
                }
                ++currentIndex;
            }
            ++currentBucket;
            currentIndex = 0;
        }
        return results;
    }

    protected abstract E getElementFromIndex(ResourceResolver var1, String var2, String var3);

    protected abstract <C> C getComponentElementFromIndex(ResourceResolver var1, String var2, String var3, IndexElementFactory<C> var4);

    private static class FindBucketAndLocWrapper {
        private final int bucketLoc;
        private final int indexLoc;

        private FindBucketAndLocWrapper(int bucketLoc, int indexLoc) {
            this.bucketLoc = bucketLoc;
            this.indexLoc = indexLoc;
        }
    }

    private static class FindIndexWrapper {
        private final int indexLoc;
        private final Resource indexResource;
        private final String index;

        private FindIndexWrapper(int indexLoc, Resource indexResource, String index) {
            this.indexLoc = indexLoc;
            this.indexResource = indexResource;
            this.index = index;
        }
    }

    public static class LongComparator
    implements Comparator<Long> {
        @Override
        public int compare(Long o1, Long o2) {
            return o1.compareTo(o2);
        }
    }
}

