/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.index;

import com.adobe.cq.social.storage.index.EventTopicsType;
import com.adobe.cq.social.storage.index.IndexHandler;
import com.adobe.cq.social.storage.index.IndexUtil;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseIndexHandler
implements IndexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBaseIndexHandler.class);
    private Set<String> targetModifiedAttributes;
    private Set<String> targetAddedRemovedAttributes;
    private Set<String> addedResourceTypes;
    private Set<String> changedResourceTypes;
    private boolean indexResourceSubTypes;

    public AbstractBaseIndexHandler(Set<String> targetModifiedAttributes, Set<String> targetAddedRemovedAttributes, Set<String> addedResourceTypes, Set<String> changedResourceTypes) {
        this.init(targetModifiedAttributes, targetAddedRemovedAttributes, addedResourceTypes, changedResourceTypes, false);
    }

    public AbstractBaseIndexHandler(Set<String> targetModifiedAttributes, Set<String> targetAddedRemovedAttributes, Set<String> addedResourceTypes, Set<String> changedResourceTypes, boolean indexResourceSubTypes) {
        this.init(targetModifiedAttributes, targetAddedRemovedAttributes, addedResourceTypes, changedResourceTypes, indexResourceSubTypes);
    }

    private void init(Set<String> targetModifiedAttributes, Set<String> targetAddedRemovedAttributes, Set<String> addedResourceTypes, Set<String> changedResourceTypes, boolean indexResourceSubTypes) {
        this.targetModifiedAttributes = targetModifiedAttributes;
        this.targetAddedRemovedAttributes = targetAddedRemovedAttributes;
        this.addedResourceTypes = addedResourceTypes;
        this.changedResourceTypes = changedResourceTypes;
        this.indexResourceSubTypes = indexResourceSubTypes;
    }

    @Override
    public void registerAddResourceTypes(String ... resourceTypes) {
        for (String r : resourceTypes) {
            this.addedResourceTypes.add(r);
        }
    }

    @Override
    public void registerChangeResourceTypes(String ... resourceTypes) {
        for (String r : resourceTypes) {
            this.changedResourceTypes.add(r);
        }
    }

    @Override
    public void unregisterAddResourceTypes(String ... resourceTypes) {
        for (String r : resourceTypes) {
            this.addedResourceTypes.remove(r);
        }
    }

    @Override
    public void unregisterChangeResourceTypes(String ... resourceTypes) {
        for (String r : resourceTypes) {
            this.changedResourceTypes.remove(r);
        }
    }

    private boolean checkResourceType(ResourceResolver resolver, String nodePath, String resourceType, Set<String> supportedResourceTypes) {
        if (this.indexResourceSubTypes) {
            Resource resource = resolver.getResource(nodePath);
            for (String rType : supportedResourceTypes) {
                if (!ResourceUtil.isA(resource, rType)) continue;
                return true;
            }
            return false;
        }
        return supportedResourceTypes.contains(resourceType);
    }

    private boolean checkAttributes(String[] attributes, Set<String> targets) {
        if (attributes == null) {
            return false;
        }
        for (int j = 0; j < attributes.length; ++j) {
            if (!targets.contains(attributes[j])) continue;
            return true;
        }
        return false;
    }

    protected abstract void indexExec(ResourceResolver var1, String var2, Enum<EventTopicsType> var3) throws Exception;

    public boolean handleEvent(ResourceResolver resolver, String resourceType, String eventTopics, String nodePath, String[] resourceChangedAttributes, String[] resourceAddedAttributes, String[] resourceRemovedAttributes, Enum<EventTopicsType> eventTopicsType) throws Exception {
        boolean isDelete;
        boolean bl = isDelete = eventTopicsType == EventTopicsType.DELETED;
        if (isDelete) {
            String componentName = IndexUtil.getComponentName(resolver, nodePath);
            if (componentName != null && componentName.endsWith("index")) {
                return false;
            }
        } else {
            if (resourceType == null) {
                LOG.debug("Cannot index: resourceType is null");
                return false;
            }
            if (!this.checkResourceType(resolver, nodePath, resourceType, this.addedResourceTypes) || !eventTopics.equals("org/apache/sling/api/resource/Resource/ADDED")) {
                if (this.checkResourceType(resolver, nodePath, resourceType, this.changedResourceTypes) && eventTopics.equals("org/apache/sling/api/resource/Resource/CHANGED")) {
                    if (!(this.checkAttributes(resourceChangedAttributes, this.targetModifiedAttributes) || this.checkAttributes(resourceAddedAttributes, this.targetAddedRemovedAttributes) || this.checkAttributes(resourceRemovedAttributes, this.targetAddedRemovedAttributes))) {
                        LOG.debug("Will not index: relevant attributes not impacted [{}] [{}]", (Object)resourceChangedAttributes, (Object)resourceAddedAttributes);
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        this.indexExec(resolver, nodePath, eventTopicsType);
        return true;
    }
}

