/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.sc.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

class SubtreeTermEnum
extends FilteredTermEnum {
    private final String path;
    private final boolean includeRoot;
    private volatile boolean end = false;

    public SubtreeTermEnum(IndexReader reader, String path, boolean includeRoot) throws IOException {
        this.path = path;
        this.includeRoot = includeRoot;
        this.setEnum(reader.terms(new Term(":path", path)));
    }

    protected boolean termCompare(Term term) {
        String field = term.field();
        String text = term.text();
        if (field.equals(":path") && text.startsWith(this.path)) {
            if (text.equals(this.path)) {
                return this.includeRoot;
            }
            return this.path.equals("/") || text.startsWith(this.path + "/");
        }
        this.end = true;
        return false;
    }

    protected boolean endEnum() {
        return this.end;
    }

    public float difference() {
        return 1.0f;
    }
}

