/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.review.client.api;

import com.adobe.cq.social.commons.client.api.AbstractSocialComponentFactory;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.review.client.endpoints.ReviewOperations;
import com.adobe.cq.social.review.client.impl.ReviewCollectionSocialComponentImpl;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class ReviewCollectionSocialComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;
    private static final Logger LOG = LoggerFactory.getLogger(ReviewOperations.class);

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return new ReviewCollectionSocialComponentImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.listProviderManager);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        if (resource.isResourceType("social/reviews/components/hbs/summary")) {
            ValueMap values = resource.adaptTo(ValueMap.class);
            String path = (String)((Object)values.get("reviewPath", String.class));
            if (path != null && !path.isEmpty()) {
                Resource review = resource.getResourceResolver().resolve(path);
                ReviewCollectionSocialComponentImpl rc = new ReviewCollectionSocialComponentImpl(review, this.getClientUtilities(request), this.getQueryRequestInfo(request), this.listProviderManager);
                boolean includeHistogram = values.get("includeHistogram", false);
                rc.setIncludeHistogram(includeHistogram);
                return rc;
            }
            LOG.error("Resource's reviewPath property is empty {} ", (Object)resource.getPath());
        }
        return new ReviewCollectionSocialComponentImpl(resource, this.getClientUtilities(request), this.getQueryRequestInfo(request), this.listProviderManager);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo) {
        return new ReviewCollectionSocialComponentImpl(resource, clientUtils, queryInfo, this.listProviderManager);
    }

    @Override
    public String getSupportedResourceType() {
        return "social/reviews/components/hbs/reviews";
    }

    protected void bindListProviderManager(CommentSocialComponentListProviderManager commentSocialComponentListProviderManager) {
        this.listProviderManager = commentSocialComponentListProviderManager;
    }

    protected void unbindListProviderManager(CommentSocialComponentListProviderManager commentSocialComponentListProviderManager) {
        if (this.listProviderManager == commentSocialComponentListProviderManager) {
            this.listProviderManager = null;
        }
    }
}

