/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.moderation.util.common;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModerationUtilities {
    public static final Logger log = LoggerFactory.getLogger(ModerationUtilities.class);

    public static Node addTimeBucket(PageManager mgr, Node targetNode, Date date) throws WCMException, RepositoryException {
        String parentPath = targetNode.getPath();
        String year = new SimpleDateFormat("yyyy").format(date);
        String yearPath = parentPath + "/" + year;
        String month = new SimpleDateFormat("MM").format(date);
        String monthPath = yearPath + "/" + month;
        String day = new SimpleDateFormat("dd").format(date);
        String dayPath = monthPath + "/" + day;
        Page dayPage = mgr.getPage(dayPath);
        Page monthPage = mgr.getPage(monthPath);
        Page yearPage = mgr.getPage(yearPath);
        Node node = null;
        if (dayPage == null) {
            if (monthPage == null) {
                if (yearPage == null) {
                    yearPage = mgr.create(parentPath, year, null, year);
                }
                monthPage = mgr.create(yearPage.getPath(), month, null, month);
            }
            dayPage = mgr.create(monthPage.getPath(), day, null, day);
        }
        node = dayPage.getContentResource().adaptTo(Node.class);
        return node;
    }

    public static String getPathArray(String payload) throws JSONException {
        JSONArray array = new JSONArray(payload);
        if (array == null || array.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length(); ++i) {
            sb.append(",'").append(((JSONObject)array.get(i)).getString("path")).append("'");
        }
        return sb.substring(1);
    }
}

