/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.messaging.client.api;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.messaging.client.api.AbstractMessagingComponentFactory;
import com.adobe.cq.social.messaging.client.impl.UserChooserComponentImpl;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

@Component(label="AEM Social Communities User Chooser SocialComponent Factory")
@Service(value={SocialComponentFactory.class})
public class UserChooserSocialComponentFactory
extends AbstractMessagingComponentFactory {
    public static final String RESOURCE_TYPE = "social/messaging/components/hbs/userchooser";
    private static final String DEFAULT_PAGE_SIZE_NAME = "defaultPageSize";
    private static final int DEFAULT_PAGE_SIZE_VALUE = 25;
    @Property(name="defaultPageSize", intValue={25})
    private int pageSize;

    @Override
    protected void activate(ComponentContext context) {
        super.activate(context);
        this.pageSize = OsgiUtil.toInteger(context.getProperties().get(DEFAULT_PAGE_SIZE_NAME), 25);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return this.getSocialComponent(resource, null);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest slingRequest) {
        if (resource == null && slingRequest == null) {
            throw new IllegalArgumentException("Cannot create a User Chooser without a non-null resource or sling request.");
        }
        ClientUtilities clientUtils = null;
        clientUtils = slingRequest == null ? this.getClientUtilities(resource.getResourceResolver()) : this.getClientUtilities(slingRequest);
        return this.getSocialComponent(resource, clientUtils, this.getQueryRequestInfo(slingRequest));
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryRequestInfo) {
        return new UserChooserComponentImpl(resource, clientUtils, queryRequestInfo, this.getResolverFactory(), this.getUserPropertiesService(), this.pageSize);
    }

    @Override
    public String getSupportedResourceType() {
        return RESOURCE_TYPE;
    }
}

