/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.messaging.client.api;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.messaging.client.api.AbstractMessagingComponentFactory;
import com.adobe.cq.social.messaging.client.impl.MessagingUserImpl;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="MessagingUserComponentFactory", metatype=true)
@Service(value={SocialComponentFactory.class})
public class MessagingUserComponentFactory
extends AbstractMessagingComponentFactory
implements SocialComponentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MessagingUserComponentFactory.class);

    @Override
    public String getSupportedResourceType() {
        return "social/messaging/user";
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot create a messaging user with a null resource.");
        }
        return this.getSocialComponent(resource, this.getClientUtilities(resource.getResourceResolver()), null);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        if (resource == null && request == null) {
            throw new IllegalArgumentException("Cannot create a messaging user without a valid resource or sling request.");
        }
        ClientUtilities clientUtils = null;
        clientUtils = request == null ? this.getClientUtilities(resource.getResourceResolver()) : this.getClientUtilities(request);
        return this.getSocialComponent(resource, clientUtils, this.getQueryRequestInfo(request));
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo requestInfo) {
        ResourceResolver resourceResolver = resource.getResourceResolver();
        Authorizable auth = null;
        try {
            auth = resource.adaptTo(Authorizable.class);
        }
        catch (Exception e) {
            LOG.debug("Unable to adapt resource at path {} to Authorizable.  Trying with userID Unknown.", (Object)resource.getPath());
        }
        try {
            String userId = "Unknown";
            boolean group = false;
            if (auth != null) {
                userId = auth.getID();
                group = auth.isGroup();
            } else {
                userId = resource.getPath().substring(resource.getPath().lastIndexOf("/") + 1);
            }
            UserPropertiesManager upm = resourceResolver.adaptTo(UserPropertiesManager.class);
            UserProperties properties = null;
            if (upm != null) {
                properties = upm.getUserProperties(userId, "profile");
            }
            return new MessagingUserImpl(properties, clientUtils, group, clientUtils.getUser(userId, resourceResolver));
        }
        catch (RepositoryException e) {
            LOG.error("Error creating messaging user component ", (Throwable)e);
            return null;
        }
    }
}

