/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.messaging.client.api;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.messaging.api.MessagingService;
import com.adobe.cq.social.messaging.client.api.AbstractMessagingComponentFactory;
import com.adobe.cq.social.messaging.client.impl.MessageSocialComponentImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;

@Component(label="AEM Social Communities MessageSocialComponentFactory")
@Service(value={SocialComponentFactory.class})
public class MessageSocialComponentFactory
extends AbstractMessagingComponentFactory {
    public static final String MESSAGE_RESOURCE_TYPE = "social/messaging/components/hbs/message";
    public static final String JCR_ALL = "jcr:.*";
    private ServiceTracker messagingServiceTracker;

    @Override
    @Activate
    protected void activate(ComponentContext context) {
        this.messagingServiceTracker = new ServiceTracker(context.getBundleContext(), MessagingService.class.getName(), null);
        this.messagingServiceTracker.open();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.messagingServiceTracker.close();
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return this.getSocialComponent(resource, null);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest slingRequest) {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot create a message with a null resource.");
        }
        ClientUtilities clientUtils = null;
        clientUtils = slingRequest == null ? this.getClientUtilities(resource.getResourceResolver()) : this.getClientUtilities(slingRequest);
        return this.getSocialComponent(resource, clientUtils, this.getQueryRequestInfo(slingRequest));
    }

    private Set<String> getCustomPropertiesWhiteList() {
        Object prop;
        ServiceReference srvRef = this.messagingServiceTracker.getServiceReference();
        if (srvRef != null && (prop = srvRef.getProperty("message.properties")) != null) {
            return new HashSet<String>(Arrays.asList(OsgiUtil.toStringArray(prop, new String[0])));
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtilities, QueryRequestInfo queryRequestInfo) {
        return new MessageSocialComponentImpl(resource, clientUtilities, this.getResolverFactory(), this.getUserPropertiesService(), this.getCustomPropertiesWhiteList()){

            protected List<String> getIgnoredProperties() {
                for (String ignore : MessageSocialComponentFactory.this.getCustomPropertiesWhiteList()) {
                    if (this.ignoredProperties.contains(ignore)) continue;
                    this.ignoredProperties.add(ignore);
                }
                if (!this.ignoredProperties.contains(MessageSocialComponentFactory.JCR_ALL)) {
                    this.ignoredProperties.add(MessageSocialComponentFactory.JCR_ALL);
                }
                return this.ignoredProperties;
            }
        };
    }

    @Override
    public String getSupportedResourceType() {
        return MESSAGE_RESOURCE_TYPE;
    }
}

