/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.messaging.client.api;

import com.adobe.cq.social.commons.client.api.AbstractSocialComponentFactory;
import com.adobe.cq.social.commons.client.api.BaseQueryRequestInfo;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.granite.security.user.UserPropertiesService;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolverFactory;

@Component(componentAbstract=true, metatype=true)
abstract class AbstractMessagingComponentFactory
extends AbstractSocialComponentFactory {
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private UserPropertiesService userPropertiesService;

    AbstractMessagingComponentFactory() {
    }

    @Override
    protected QueryRequestInfo getQueryRequestInfo(final SlingHttpServletRequest request) {
        if (request != null) {
            return new BaseQueryRequestInfo(request){

                @Override
                public Map<String, String[]> getPredicates() {
                    return AbstractMessagingComponentFactory.getParameters(request);
                }
            };
        }
        return null;
    }

    private static Map<String, String[]> getParameters(SlingHttpServletRequest request) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
            params.put((String)entry.getKey(), (String[])entry.getValue());
        }
        return params;
    }

    protected ResourceResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }

    protected UserPropertiesService getUserPropertiesService() {
        return this.userPropertiesService;
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindUserPropertiesService(UserPropertiesService userPropertiesService) {
        this.userPropertiesService = userPropertiesService;
    }

    protected void unbindUserPropertiesService(UserPropertiesService userPropertiesService) {
        if (this.userPropertiesService == userPropertiesService) {
            this.userPropertiesService = null;
        }
    }
}

