/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.journal;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.journal.Journal;
import com.adobe.cq.social.journal.JournalEntry;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.security.profile.Profile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalUtil {
    private static final Logger log = LoggerFactory.getLogger(JournalUtil.class);

    private JournalUtil() {
    }

    public static String getParentPath(String pagePath, Date archiveDate) {
        StringBuffer parent = new StringBuffer(pagePath);
        parent.append("/");
        parent.append(new SimpleDateFormat("yyyy").format(archiveDate));
        parent.append("/");
        parent.append(new SimpleDateFormat("MM").format(archiveDate));
        return parent.toString();
    }

    public static JournalEntry getJournalEntryUGC(Resource resource) throws RepositoryException {
        String resourcePath = resource.getPath();
        Node node = resource.adaptTo(Node.class);
        Date publishDate = node.getProperty("published").getDate().getTime();
        StringBuffer entryPagePath = new StringBuffer(JournalUtil.getParentPath(resourcePath.substring("/content/usergenerated".length(), resourcePath.indexOf("/jcr:content")), publishDate));
        entryPagePath.append("/");
        String name = node.getProperty("jcr:title").getString();
        if (name.length() > 20) {
            name = name.substring(0, 20);
        }
        entryPagePath.append(JcrUtil.createValidName(name));
        Resource entryPageResource = resource.getResourceResolver().getResource(entryPagePath.toString());
        return entryPageResource.adaptTo(JournalEntry.class);
    }

    public static List<String> deleteEntry(Resource resource) throws RepositoryException {
        String resourcePath = resource.getPath();
        JournalEntry entry = resourcePath.startsWith("/content/usergenerated") ? JournalUtil.getJournalEntryUGC(resource) : resource.adaptTo(JournalEntry.class);
        String path = null;
        String textPath = null;
        path = entry.getPage().getPath() + "/" + "jcr:content" + "/" + "par/entry";
        Node node = resource.getResourceResolver().getResource(path).adaptTo(Node.class);
        textPath = node.getProperty("text").getString();
        String commentPath = "/content/usergenerated" + entry.getResource().getPath();
        if (commentPath.endsWith("jcr:content")) {
            commentPath = commentPath.substring(0, commentPath.lastIndexOf(47));
        }
        String pagePath = entry.getPage().getPath();
        entry.getJournal().deleteEntry(entry);
        LinkedList<String> replicationPaths = new LinkedList<String>();
        if (textPath != null && textPath.length() > 0) {
            replicationPaths.add(pagePath);
            replicationPaths.add(textPath);
            replicationPaths.add(commentPath);
        }
        return replicationPaths;
    }

    public static boolean mayCreateEntry(ResourceResolver resolver, Journal journal) {
        if (null != resolver && null != journal) {
            if ("anonymous".equals(resolver.adaptTo(Session.class).getUserID())) {
                return false;
            }
            return CollabUtil.canAddNode(resolver.adaptTo(Session.class), journal.getPage().getPath());
        }
        return false;
    }

    @Deprecated
    public static boolean mayEditEntry(Session session, Profile authorizable, JournalEntry entry) {
        if (null != session && null != entry) {
            if ("anonymous".equals(session.getUserID())) {
                return false;
            }
            if (!entry.getAuthor().equals(authorizable.getFormattedName())) {
                return false;
            }
            return CollabUtil.canAddNode(session, entry.getPage().getPath());
        }
        return false;
    }

    public static boolean mayEditEntry(Session session, UserProperties authorizable, JournalEntry entry) {
        try {
            if (null != session && null != entry) {
                if ("anonymous".equals(session.getUserID())) {
                    return false;
                }
                if (!entry.getAuthor().equals(authorizable.getDisplayName())) {
                    return false;
                }
                return CollabUtil.canAddNode(session, entry.getPage().getPath());
            }
        }
        catch (RepositoryException re) {
            log.warn("Cannot access display name.", (Throwable)re);
        }
        return false;
    }
}

