/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.journal;

import com.adobe.cq.social.journal.Journal;
import com.day.cq.wcm.api.Page;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class JournalArchive {
    private final List<Period> periods;
    private static final DateFormat DEFAULT_TITLE_FORMAT = new SimpleDateFormat("MMMMM yyyy");
    private static final DateFormat DEFAULT_YEAR_FORMAT = new SimpleDateFormat("yyyy");
    private final DateFormat titleFormat;
    private final Journal journal;
    private final int max;

    public JournalArchive(Journal j, int m, DateFormat df) {
        this.journal = j;
        this.max = m;
        this.titleFormat = df != null ? df : DEFAULT_TITLE_FORMAT;
        this.periods = new ArrayList<Period>();
    }

    public List<Period> getPeriods() {
        if (this.periods.size() == 0) {
            Iterator<Page> years = this.journal.getPage().listChildren();
            block0: while (years.hasNext()) {
                Page year = years.next();
                if (year.getName().equals("unlisted") || year.getProperties().get("journalarchive", null) == null) continue;
                Iterator<Page> months = year.listChildren();
                while (months.hasNext()) {
                    Page month = months.next();
                    String period = year.getName() + "/" + month.getName();
                    this.periods.add(this.getPeriod(period));
                    if (this.max <= 0 || this.periods.size() < this.max) continue;
                    continue block0;
                }
            }
        }
        Collections.sort(this.periods, new Comparator<Period>(){

            @Override
            public int compare(Period p1, Period p2) {
                return -p1.getId().compareTo(p2.getId());
            }
        });
        return this.periods;
    }

    private Period getPeriod(String period) {
        for (Period p : this.periods) {
            if (!period.equals(p.getId())) continue;
            return p;
        }
        return new Period(period, JournalArchive.getPeriodTitle(period, this.titleFormat));
    }

    public static String getPeriodTitle(String period, DateFormat monthDf) {
        return JournalArchive.getPeriodTitle(period, monthDf, null);
    }

    public static String getPeriodTitle(String period, DateFormat monthDf, DateFormat yearDf) {
        if (monthDf == null) {
            monthDf = DEFAULT_TITLE_FORMAT;
        }
        try {
            if (period.indexOf("/") != -1) {
                String[] fields = period.split("/");
                int year = Integer.parseInt(fields[0]);
                int month = Integer.parseInt(fields[1]) - 1;
                Calendar calendar = Calendar.getInstance();
                calendar.set(year, month, 1);
                return monthDf.format(calendar.getTime());
            }
            if (yearDf == null) {
                yearDf = DEFAULT_YEAR_FORMAT;
            }
            int year = Integer.parseInt(period);
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, 1, 1);
            return yearDf.format(calendar.getTime());
        }
        catch (NumberFormatException nfe) {
            return period;
        }
    }

    public class Period {
        private final String id;
        private final String url;
        private final String title;

        public Period(String period, String t) {
            this.id = period;
            this.title = t;
            this.url = this.getUrl(period);
        }

        public String getUrl() {
            return this.url;
        }

        public String getTitle() {
            return this.title;
        }

        public String getId() {
            return this.id;
        }

        private String getUrl(String period) {
            return JournalArchive.this.journal.getPage().getPath() + "/" + period + ".html";
        }
    }
}

