/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.handlebars.TemplateLocationIterator;
import com.adobe.cq.social.handlebars.api.TemplateContextProvider;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateUtils.class);

    public static Map<String, Resource> collectTemplates(ResourceResolver resolver, Resource baseResource) {
        LinkedHashMap<String, Resource> templates = new LinkedHashMap<String, Resource>();
        Resource parentResource = resolver.getResource(baseResource.getResourceType());
        while (parentResource != null) {
            for (Resource childResource : parentResource.getChildren()) {
                if (!StringUtils.endsWith((CharSequence)childResource.getName(), (CharSequence)".hbs")) continue;
                String templateName = StringUtils.removeEnd((String)childResource.getName(), (String)".hbs");
                templates.put(templateName, childResource);
                LOG.error("Found item with .hbs extension: ", (Object)childResource.getPath());
            }
            parentResource = resolver.getResource(parentResource.getResourceSuperType());
        }
        return templates;
    }

    public static Resource findTemplate(ResourceResolver resolver, String resourceType, String scriptName) {
        String scriptToSearchFor;
        LinkedHashMap<String, Resource> templates = new LinkedHashMap<String, Resource>();
        TemplateLocationIterator iterator = new TemplateLocationIterator(resourceType, resolver);
        String scriptForResourceType = StringUtils.substringAfterLast((String)resourceType, (String)"/");
        String string = scriptToSearchFor = scriptName == null ? scriptForResourceType : scriptName;
        while (iterator.hasNext()) {
            Resource parentResource = resolver.getResource(iterator.next());
            if (parentResource == null) continue;
            for (Resource childResource : parentResource.getChildren()) {
                if (!StringUtils.endsWith((CharSequence)childResource.getName(), (CharSequence)".hbs")) continue;
                String templateName = StringUtils.removeEnd((String)childResource.getName(), (String)".hbs");
                String suffix = StringUtils.substringAfterLast((String)templateName, (String)".");
                if (StringUtils.equalsIgnoreCase((CharSequence)suffix, (CharSequence)"html") || StringUtils.equalsIgnoreCase((CharSequence)suffix, (CharSequence)"get")) {
                    templateName = StringUtils.removeEnd((String)templateName, (String)("." + suffix));
                }
                if (StringUtils.equals((CharSequence)templateName, (CharSequence)scriptToSearchFor)) {
                    return childResource;
                }
                if (!templates.containsKey(templateName)) {
                    templates.put(templateName, childResource);
                }
                LOG.debug("Found item with .hbs extension: ", (Object)childResource.getPath());
            }
        }
        if (templates.size() == 0) {
            return null;
        }
        return templates.containsKey(scriptForResourceType) ? (Resource)templates.get(scriptForResourceType) : (Resource)templates.values().toArray()[0];
    }

    public static InputStream getTemplateStream(Resource res) {
        InputStream stream;
        Node templateNode = res.adaptTo(Node.class);
        if (templateNode == null) {
            return null;
        }
        try {
            Node jcrContent = templateNode.getNode("jcr:content");
            if (jcrContent == null) {
                return null;
            }
            stream = jcrContent.getProperty("jcr:data").getBinary().getStream();
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
        return stream;
    }

    public static Map<String, Object> getMergedContexts(Map<String, Object> resourceContext, List<TemplateContextProvider> contextProviders, SlingHttpServletRequest request) {
        HashMap<String, Object> mergedContext = new HashMap<String, Object>(resourceContext);
        for (TemplateContextProvider provider : contextProviders) {
            Map<String, Object> context = provider.getContext(request, resourceContext);
            String key = provider.getContextKey();
            if ("#root".equals(key)) {
                for (Map.Entry<String, Object> entry : context.entrySet()) {
                    if (mergedContext.containsKey(entry.getKey())) continue;
                    mergedContext.put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (mergedContext.containsKey(key)) continue;
            mergedContext.put(key, context);
        }
        return mergedContext;
    }
}

