/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.handlebars.DefaultHelpersRegister;
import com.adobe.cq.social.handlebars.TemplateContextProviderService;
import com.adobe.cq.social.handlebars.api.TemplateHelper;
import com.adobe.cq.social.handlebars.api.TemplateHelpersService;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.widget.HtmlLibraryManager;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.helper.MethodHelper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Handlebars Template Helpers Service", description="Handlebars Template Helpers Service", enabled=true)
@Service
@References(value={@Reference(name="templateHelper", referenceInterface=TemplateHelper.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class TemplateHelpersServiceImpl
implements TemplateHelpersService {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateHelpersServiceImpl.class);
    private DefaultHelpersRegister defaultHelpers;
    @Reference
    private TemplateContextProviderService contextProviderService;
    @Reference
    private XSSAPI xssAPI;
    @Reference
    private HtmlLibraryManager htmlLibraryManager;
    private final List<TemplateHelper> templateHelpers = new CopyOnWriteArrayList<TemplateHelper>();
    private final Set<Handlebars> handlebarsSeen = new HashSet<Handlebars>(1);

    @Override
    public void registerHelpers(Handlebars handlebars, ResourceResolver adminResolver) {
        this.handlebarsSeen.add(handlebars);
        try {
            this.defaultHelpers.registerStaticHelpers(handlebars, adminResolver);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Exception when registering helpers ", (Throwable)e);
        }
        for (TemplateHelper helper : this.templateHelpers) {
            this.registerStaticHelper(helper, handlebars);
        }
    }

    protected synchronized void bindTemplateHelper(TemplateHelper helper) {
        this.templateHelpers.add(helper);
        this.addToSeenHandlebars(helper);
    }

    protected synchronized void unbindTemplateHelper(TemplateHelper helper) {
        this.templateHelpers.remove(helper);
        this.removeHelper(helper);
    }

    private synchronized void removeHelper(TemplateHelper helper) {
        final String helperName = helper.getHelperName();
        final String className = helper.getClass().getCanonicalName();
        for (Handlebars handlebars : this.handlebarsSeen) {
            handlebars.registerHelper(helper.getHelperName(), (Helper)new Helper<Object>(){

                public CharSequence apply(Object context, Options options) throws IOException {
                    throw new IOException("Trying to use unregistered helper " + helperName + " provided by " + className);
                }
            });
        }
    }

    private void addToSeenHandlebars(TemplateHelper helper) {
        for (Handlebars handlebars : this.handlebarsSeen) {
            this.registerStaticHelper(helper, handlebars);
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.defaultHelpers = new DefaultHelpersRegister(this.xssAPI, this.contextProviderService, this.htmlLibraryManager);
    }

    private synchronized void registerStaticHelper(TemplateHelper helper, Handlebars handlebars) {
        try {
            Class applyType = helper.getContextType();
            Method applyMethod = helper.getClass().getMethod("apply", applyType, Options.class);
            handlebars.registerHelper(helper.getHelperName(), (Helper)new MethodHelper(applyMethod, (Object)helper));
        }
        catch (SecurityException e) {
            LOG.error("Exception adding helper " + helper.getClass(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Exception adding helper " + helper.getClass(), (Throwable)e);
        }
    }

    protected void bindContextProviderService(TemplateContextProviderService templateContextProviderService) {
        this.contextProviderService = templateContextProviderService;
    }

    protected void unbindContextProviderService(TemplateContextProviderService templateContextProviderService) {
        if (this.contextProviderService == templateContextProviderService) {
            this.contextProviderService = null;
        }
    }

    protected void bindXssAPI(XSSAPI xSSAPI) {
        this.xssAPI = xSSAPI;
    }

    protected void unbindXssAPI(XSSAPI xSSAPI) {
        if (this.xssAPI == xSSAPI) {
            this.xssAPI = null;
        }
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }
}

