/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.handlebars.TemplateContextProviderService;
import com.adobe.cq.social.handlebars.api.TemplateContextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;

@Component(label="Template Context Provider Factory", description="Template Context Provider Factory", metatype=true)
@Service(value={TemplateContextProviderService.class})
@Reference(name="templateContextProviders", referenceInterface=TemplateContextProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindTemplateContextProviders", unbind="unbindTemplateContextProviders")
public class TemplateContextProviderServiceImpl
implements TemplateContextProviderService {
    private ComponentContext context;
    private final List<TemplateContextProvider> boundProviders = new LinkedList<TemplateContextProvider>();
    private final Map<String, List<TemplateContextProvider>> providers = Collections.synchronizedMap(new HashMap());

    @Override
    public List<TemplateContextProvider> getProviders(String resourceType) {
        ArrayList<TemplateContextProvider> providerList = new ArrayList<TemplateContextProvider>();
        if (this.providers.containsKey("#all")) {
            providerList.addAll((Collection)this.providers.get("#all"));
        }
        if (this.providers.containsKey(resourceType)) {
            providerList.addAll((Collection<TemplateContextProvider>)this.providers.get(resourceType));
        }
        return providerList;
    }

    public void addProvider(TemplateContextProvider provider) {
        for (String resourceType : provider.getResourceTypes()) {
            List<Object> providersForType;
            if (this.providers.containsKey(resourceType)) {
                providersForType = this.providers.get(resourceType);
                providersForType.add(provider);
                this.providers.put(resourceType, providersForType);
                continue;
            }
            providersForType = new ArrayList<TemplateContextProvider>();
            providersForType.add(provider);
            this.providers.put(resourceType, providersForType);
        }
    }

    public void removeProvider(TemplateContextProvider provider) {
        for (String resourceType : provider.getResourceTypes()) {
            if (!this.providers.containsKey(resourceType)) continue;
            List<TemplateContextProvider> providersForType = this.providers.get(resourceType);
            providersForType.remove(provider);
            if (providersForType.isEmpty()) {
                this.providers.remove(resourceType);
                continue;
            }
            this.providers.put(resourceType, providersForType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext componentContext) {
        ArrayList<TemplateContextProvider> providersCopy;
        List<TemplateContextProvider> list = this.boundProviders;
        synchronized (list) {
            providersCopy = new ArrayList<TemplateContextProvider>(this.boundProviders);
            this.boundProviders.clear();
        }
        for (TemplateContextProvider provider : providersCopy) {
            this.addProvider(provider);
        }
        this.context = componentContext;
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        this.context = null;
    }

    protected void unbindTemplateContextProviders(TemplateContextProvider provider) {
        this.removeProvider(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindTemplateContextProviders(TemplateContextProvider provider) {
        boolean addProvider = true;
        if (this.context == null) {
            List<TemplateContextProvider> list = this.boundProviders;
            synchronized (list) {
                if (this.context == null) {
                    this.boundProviders.add(provider);
                    addProvider = false;
                }
            }
        }
        if (addProvider) {
            this.addProvider(provider);
        }
    }
}

