/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.granite.xss.XSSAPI;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.paths", value={"/services/social/includehelper"})})
public class SlingIncludeServlet
extends SlingSafeMethodsServlet {
    private static final String SELECTOR = "selector";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String RESOURCE_PATH = "resourcePath";
    protected static final String CONTENT_TYPE = "application/json";
    protected static final String ENCODING = "utf-8";
    protected static final Boolean DEFAULT_TIDY = Boolean.FALSE;
    private static final long serialVersionUID = 1L;
    @Reference
    private XSSAPI xss;

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String resourcePath = request.getParameter(RESOURCE_PATH);
        String resourceType = request.getParameter(RESOURCE_TYPE);
        String selector = request.getParameter(SELECTOR);
        if (resourcePath == null) {
            response.sendError(204);
            return;
        }
        Resource resource = request.getResourceResolver().resolve(resourcePath);
        response.setHeader("Content-Type", "text/html");
        response.setCharacterEncoding(ENCODING);
        SlingHttpServletRequestWrapper includeRequest = new SlingHttpServletRequestWrapper(request){

            public String getMethod() {
                return "GET";
            }
        };
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        if (null != selector) {
            options.setReplaceSelectors(selector);
        }
        if (null != resourceType) {
            options.setForceResourceType(resourceType);
        }
        options.setReplaceSuffix("html");
        includeRequest.getRequestDispatcher(resource, options).include((ServletRequest)includeRequest, (ServletResponse)response);
        response.setStatus(200);
        response.setHeader("Location", resourcePath);
    }

    protected void bindXss(XSSAPI xSSAPI) {
        this.xss = xSSAPI;
    }

    protected void unbindXss(XSSAPI xSSAPI) {
        if (this.xss == xSSAPI) {
            this.xss = null;
        }
    }
}

