/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;

public class SlingIncludeHelper {
    private final SlingHttpServletRequest request;
    private final SlingHttpServletResponse response;

    public SlingIncludeHelper(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String slingInclude(String resourcePath, String resourceType, String selector) throws ServletException, IOException {
        Resource newResource;
        SlingHttpServletRequestWrapper includeRequest = new SlingHttpServletRequestWrapper(this.request);
        RequestDispatcherOptions dispatcherOptions = new RequestDispatcherOptions();
        if (selector != null) {
            dispatcherOptions.setReplaceSelectors(selector);
        }
        if (resourceType != null) {
            dispatcherOptions.setForceResourceType(resourceType);
        }
        if ((newResource = this.request.getResourceResolver().getResource(resourcePath)) == null) {
            if (resourceType != null) {
                newResource = new SyntheticResource(this.request.getResourceResolver(), resourcePath, resourceType);
            } else {
                return "";
            }
        }
        String encoding = this.response.getCharacterEncoding();
        BufferedServletOutputStream bsops = new BufferedServletOutputStream(encoding);
        try {
            CaptureResponseWrapper wrapper = new CaptureResponseWrapper(this.response, bsops);
            includeRequest.getRequestDispatcher(newResource, dispatcherOptions).include((ServletRequest)includeRequest, (ServletResponse)wrapper);
            wrapper.flushBuffer();
            String string = bsops.getBuffer();
            return string;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)((Object)bsops));
        }
    }

    private static final class BufferedServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream baops = new ByteArrayOutputStream();
        private final String encoding;

        public BufferedServletOutputStream(String encoding) {
            this.encoding = encoding;
        }

        public String getBuffer() throws IOException {
            return this.baops.toString(this.encoding);
        }

        public void close() throws IOException {
            this.baops.reset();
            super.close();
        }

        public void write(int b) throws IOException {
            this.baops.write(b);
        }
    }

    private static final class CaptureResponseWrapper
    extends HttpServletResponseWrapper {
        private final String encoding;
        private final ServletOutputStream ops;
        private boolean isBinaryResponse = false;
        private PrintWriter writer = null;

        CaptureResponseWrapper(HttpServletResponse response, ServletOutputStream ops) {
            super(response);
            this.encoding = response.getCharacterEncoding();
            this.ops = ops;
        }

        public boolean isBinaryResponse() {
            return this.isBinaryResponse;
        }

        public void flushBuffer() throws IOException {
            if (this.isBinaryResponse()) {
                this.getResponse().getOutputStream().flush();
            } else if (this.writer != null) {
                this.writer.flush();
            } else {
                throw new IOException("Flushing the buffer on a un-initialized PrintWriter.");
            }
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IOException("'getWriter()' has already been invoked for a character data response.");
            }
            this.isBinaryResponse = true;
            return this.getResponse().getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer != null) {
                return this.writer;
            }
            if (this.isBinaryResponse) {
                throw new IOException("'getOutputStream()' has already been invoked for a binary data response.");
            }
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.ops, this.encoding));
            return this.writer;
        }
    }
}

