/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.ClientUtilityFactory;
import com.adobe.cq.social.commons.client.api.User;
import com.adobe.cq.social.handlebars.api.TemplateContextProvider;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.xss.XSSAPI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;

@Service
@Component
public class LoggedInUserContext
implements TemplateContextProvider {
    @Reference
    private XSSAPI xss;
    @Reference
    private SocialUtils socialUtils;
    @Reference
    private ClientUtilityFactory clientUtilFactory;

    @Override
    public List<String> getResourceTypes() {
        return Arrays.asList("#all");
    }

    @Override
    public Map<String, Object> getContext(SlingHttpServletRequest request, Map<String, Object> contextFromResource) {
        HashMap<String, Object> user = new HashMap<String, Object>(5);
        String userId = request.getResourceResolver().getUserID();
        ClientUtilities clientUtils = this.clientUtilFactory.getClientUtilities(this.xss, request, this.socialUtils);
        User u = clientUtils.getUser(userId, request.getResourceResolver());
        if (!"anonymous".equals(u.getName())) {
            user.put("loggedIn", true);
            user.putAll(u.getAsMap());
        } else {
            user.put("loggedIn", false);
        }
        return user;
    }

    @Override
    public String getContextKey() {
        return "loggedInUser";
    }

    protected void bindXss(XSSAPI xSSAPI) {
        this.xss = xSSAPI;
    }

    protected void unbindXss(XSSAPI xSSAPI) {
        if (this.xss == xSSAPI) {
            this.xss = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        this.clientUtilFactory = clientUtilityFactory;
    }

    protected void unbindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        if (this.clientUtilFactory == clientUtilityFactory) {
            this.clientUtilFactory = null;
        }
    }
}

