/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.handlebars.SlingIncludeHelper;
import com.adobe.cq.social.handlebars.SlingTemplateSource;
import com.adobe.cq.social.handlebars.TemplateContextProviderService;
import com.adobe.cq.social.handlebars.TemplateUtils;
import com.adobe.cq.social.handlebars.api.TemplateContextProvider;
import com.day.cq.wcm.api.WCMMode;
import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeHelper
implements Helper<Object> {
    private static final String PATH = "path";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String TEMPLATE = "template";
    private static final String AUTHORING_DISABLED = "authoringDisabled";
    private static final String SEPARATOR = "/";
    private static final String ID = "id";
    private static final Logger LOG = LoggerFactory.getLogger(IncludeHelper.class);
    public static final String name = "include";
    private final ResourceResolver resolver;
    private final TemplateContextProviderService contextProviderService;

    public IncludeHelper(ResourceResolver adminResolver, TemplateContextProviderService contextProviderService) throws NoSuchMethodException {
        this.resolver = adminResolver;
        this.contextProviderService = contextProviderService;
    }

    private Handlebars.SafeString include(String context, Options options) throws IOException, ServletException {
        SlingHttpServletRequest request = (SlingHttpServletRequest)options.get("_request");
        SlingHttpServletResponse response = (SlingHttpServletResponse)options.get("_response");
        String idFromContext = context;
        String path = (String)options.hash.get(PATH);
        boolean isPathAbsolute = StringUtils.startsWith((CharSequence)path, (CharSequence)SEPARATOR);
        String idToRender = isPathAbsolute ? path : idFromContext + SEPARATOR + path;
        SlingIncludeHelper slingInclude = new SlingIncludeHelper(request, response);
        String resourceType = (String)options.hash.get(RESOURCE_TYPE);
        String scriptPath = (String)options.hash.get(TEMPLATE);
        return new Handlebars.SafeString((CharSequence)slingInclude.slingInclude(idToRender, resourceType, scriptPath));
    }

    private Handlebars.SafeString include(Map<String, Object> context, Options options) throws IOException, ServletException {
        SlingHttpServletRequest request = (SlingHttpServletRequest)options.get("_request");
        SlingHttpServletResponse response = (SlingHttpServletResponse)options.get("_response");
        String idFromContext = (String)context.get(ID);
        String resourceType = (String)options.hash.get(RESOURCE_TYPE);
        String resourceTypeFromContext = (String)context.get(RESOURCE_TYPE);
        String scriptPath = (String)options.hash.get(TEMPLATE);
        boolean authoringDisabled = Boolean.parseBoolean((String)options.hash.get(AUTHORING_DISABLED));
        WCMMode wcmMode = WCMMode.fromRequest((ServletRequest)request);
        if (resourceType == null && resourceTypeFromContext == null) {
            return new Handlebars.SafeString((CharSequence)"");
        }
        String resourceTypeToRender = resourceType == null ? resourceTypeFromContext : resourceType;
        Resource matchedTemplate = TemplateUtils.findTemplate(this.resolver, resourceTypeToRender, scriptPath);
        if (matchedTemplate == null) {
            if (idFromContext == null) {
                return new Handlebars.SafeString((CharSequence)"");
            }
            SlingIncludeHelper slingInclude = new SlingIncludeHelper(request, response);
            return new Handlebars.SafeString((CharSequence)slingInclude.slingInclude(idFromContext, resourceTypeToRender, scriptPath));
        }
        if (!authoringDisabled && wcmMode != null && (WCMMode.DESIGN.equals((Object)wcmMode) || WCMMode.EDIT.equals((Object)wcmMode))) {
            request.setAttribute("_bypassComponentHandling", true);
            SlingIncludeHelper slingInclude = new SlingIncludeHelper(request, response);
            return new Handlebars.SafeString((CharSequence)slingInclude.slingInclude(idFromContext, resourceTypeToRender, scriptPath));
        }
        SlingTemplateSource temp = new SlingTemplateSource(matchedTemplate, matchedTemplate.getPath());
        List<TemplateContextProvider> contextProviders = this.contextProviderService.getProviders(resourceTypeToRender);
        Map<String, Object> contextMap = TemplateUtils.getMergedContexts(context, contextProviders, request);
        Context hbContext = Context.newBuilder(contextMap).resolver(new ValueResolver[]{MapValueResolver.INSTANCE}).build();
        hbContext.data("_request", (Object)request);
        hbContext.data("_response", (Object)response);
        try {
            Template hbtemplate = options.handlebars.compile((TemplateSource)temp);
            String htmlString = hbtemplate.apply(hbContext);
            return new Handlebars.SafeString((CharSequence)htmlString);
        }
        catch (Exception e) {
            LOG.error("Complilation issue when compiling " + matchedTemplate.getPath(), (Throwable)e);
            SlingIncludeHelper slingInclude = new SlingIncludeHelper(request, response);
            return new Handlebars.SafeString((CharSequence)slingInclude.slingInclude(idFromContext, resourceTypeToRender, scriptPath));
        }
    }

    public CharSequence apply(Object context, Options options) throws IOException {
        block7: {
            if (context instanceof Map) {
                try {
                    return this.include((Map)context, options);
                }
                catch (IOException e) {
                    LOG.error("error in including template", (Throwable)e);
                    break block7;
                }
                catch (ServletException e) {
                    LOG.error("error in including template", (Throwable)e);
                    break block7;
                }
            }
            if (context instanceof String) {
                try {
                    return this.include((String)context, options);
                }
                catch (ServletException e) {
                    LOG.error("error in including template", (Throwable)e);
                }
            }
        }
        return new Handlebars.SafeString((CharSequence)"");
    }
}

