/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.day.cq.widget.HtmlLibraryManager;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeClientLibraryHelper
implements Helper<Object> {
    private static final String CATEGORIES = "categories";
    private static final String THEME = "theme";
    private static final String JS = "js";
    private static final String CSS = "css";
    private static final Logger LOG = LoggerFactory.getLogger(IncludeClientLibraryHelper.class);
    public static final String name = "includeClientLib";
    private final HtmlLibraryManager htmlLibraryManager;

    public IncludeClientLibraryHelper(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    public CharSequence apply(Object context, Options options) throws IOException {
        if (context instanceof Map) {
            try {
                return this.includeClientLib((Map)context, options);
            }
            catch (IOException e) {
                LOG.error("error in including template", (Throwable)e);
            }
            catch (ServletException e) {
                LOG.error("error in including template", (Throwable)e);
            }
        }
        return null;
    }

    private Handlebars.SafeString includeClientLib(Map<String, Object> context, Options options) throws IOException, ServletException {
        SlingHttpServletRequest request = (SlingHttpServletRequest)options.get("_request");
        StringWriter writer = new StringWriter();
        try {
            if (options.hash.containsKey(CATEGORIES)) {
                this.htmlLibraryManager.writeIncludes(request, writer, IncludeClientLibraryHelper.toArray((String)options.hash.get(CATEGORIES)));
            } else if (options.hash.containsKey(THEME)) {
                this.htmlLibraryManager.writeThemeInclude(request, writer, IncludeClientLibraryHelper.toArray((String)options.hash.get(THEME)));
            } else if (options.hash.containsKey(JS)) {
                this.htmlLibraryManager.writeJsInclude(request, (Writer)writer, IncludeClientLibraryHelper.toArray((String)options.hash.get(JS)));
            } else if (options.hash.containsKey(CSS)) {
                this.htmlLibraryManager.writeCssInclude(request, (Writer)writer, IncludeClientLibraryHelper.toArray((String)options.hash.get(JS)));
            }
        }
        catch (IOException e) {
            LOG.error("Error including client lib", (Throwable)e);
        }
        return new Handlebars.SafeString((CharSequence)writer.toString());
    }

    private static String[] toArray(String commaSeparatedList) {
        if (commaSeparatedList == null) {
            return new String[0];
        }
        String[] split = commaSeparatedList.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        return split;
    }
}

