/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

public class I18nHelper
implements Helper<String> {
    public static final String name = "i18n";

    private I18n getI18n(SlingHttpServletRequest request) {
        I18n i18n;
        Resource resource;
        PageManager pageManager = request.getResourceResolver().adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(resource = request.getResource());
        if (page == null) {
            i18n = new I18n(request);
        } else {
            Locale pageLocale = page.getLanguage(false);
            ResourceBundle resourceBundle = request.getResourceBundle(pageLocale);
            i18n = new I18n(resourceBundle);
        }
        return i18n;
    }

    public CharSequence apply(String context, Options options) throws IOException {
        String stringToTranslate;
        String comment = (String)options.hash("comment", null);
        String defaultText = (String)options.hash("default", null);
        String string = stringToTranslate = context == null ? defaultText : context;
        if (stringToTranslate == null) {
            throw new IOException("Unable to i18n because the string to translate is missing!");
        }
        SlingHttpServletRequest request = (SlingHttpServletRequest)options.data("_request");
        this.getI18n(request);
        String message = I18n.get((SlingHttpServletRequest)request, (String)stringToTranslate, (String)comment, (Object[])null);
        MessageFormat format = new MessageFormat(message);
        return format.format(options.params);
    }
}

