/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.commons.client.api.BaseSocialComponent;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.ClientUtilityFactory;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.commons.client.api.SocialComponentFactoryManager;
import com.adobe.cq.social.handlebars.HandlebarsScriptingEngine;
import com.adobe.cq.social.handlebars.TemplateContextProviderService;
import com.adobe.cq.social.handlebars.api.TemplateHelpersService;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.xss.XSSAPI;
import com.github.jknack.handlebars.Handlebars;
import javax.script.ScriptEngine;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.osgi.service.component.ComponentContext;

@Component
@Service
public class HandlebarsScriptingEngineFactory
extends AbstractScriptEngineFactory {
    public static final String[] SCRIPT_EXTENSIONS = new String[]{"hbs"};
    public static final Handlebars HANDLEBARS = new Handlebars();
    @Reference
    protected TemplateHelpersService templateHelperService;
    @Reference
    protected SocialComponentFactoryManager srf;
    @Reference
    private ResourceResolverFactory rrf;
    @Reference
    private SocialUtils socialUtils;
    @Reference
    private XSSAPI xssAPI;
    @Reference
    private TemplateContextProviderService contextProviderService;
    @Reference
    private ClientUtilityFactory clientUtilFactory;
    private ResourceResolver adminResolver;

    public HandlebarsScriptingEngineFactory() {
        this.setEngineVersion(this.getLanguageVersion());
        this.setExtensions(SCRIPT_EXTENSIONS);
        this.setNames("handlebars");
    }

    @Activate
    protected void activate(ComponentContext context) throws LoginException {
        try {
            this.adminResolver = this.rrf.getAdministrativeResourceResolver(null);
            this.templateHelperService.registerHelpers(HANDLEBARS, this.adminResolver);
        }
        catch (LoginException e) {
            this.rrf = null;
            throw e;
        }
    }

    @Override
    public String getLanguageName() {
        return "handlebars";
    }

    @Override
    public String getLanguageVersion() {
        return "1.0.0";
    }

    @Override
    public ScriptEngine getScriptEngine() {
        if (this.adminResolver != null) {
            return new HandlebarsScriptingEngine(this, HANDLEBARS, this.adminResolver);
        }
        return null;
    }

    protected SocialComponent getSocialComponentForResource(Resource resource, SlingHttpServletRequest request) {
        SocialComponentFactory factory = this.srf.getSocialComponentFactory(resource);
        if (factory == null) {
            ClientUtilities clientUtils = this.clientUtilFactory.getClientUtilities(this.xssAPI, request, this.socialUtils);
            return new BaseSocialComponent(resource, clientUtils);
        }
        SocialComponent r = factory.getSocialComponent(resource, request);
        return r;
    }

    protected TemplateContextProviderService getContextProviderService() {
        return this.contextProviderService;
    }

    public TemplateHelpersService getTemplateHelperService() {
        return this.templateHelperService;
    }

    protected void bindTemplateHelperService(TemplateHelpersService templateHelpersService) {
        this.templateHelperService = templateHelpersService;
    }

    protected void unbindTemplateHelperService(TemplateHelpersService templateHelpersService) {
        if (this.templateHelperService == templateHelpersService) {
            this.templateHelperService = null;
        }
    }

    protected void bindSrf(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.srf = socialComponentFactoryManager;
    }

    protected void unbindSrf(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.srf == socialComponentFactoryManager) {
            this.srf = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }

    protected void bindXssAPI(XSSAPI xSSAPI) {
        this.xssAPI = xSSAPI;
    }

    protected void unbindXssAPI(XSSAPI xSSAPI) {
        if (this.xssAPI == xSSAPI) {
            this.xssAPI = null;
        }
    }

    protected void bindContextProviderService(TemplateContextProviderService templateContextProviderService) {
        this.contextProviderService = templateContextProviderService;
    }

    protected void unbindContextProviderService(TemplateContextProviderService templateContextProviderService) {
        if (this.contextProviderService == templateContextProviderService) {
            this.contextProviderService = null;
        }
    }

    protected void bindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        this.clientUtilFactory = clientUtilityFactory;
    }

    protected void unbindClientUtilFactory(ClientUtilityFactory clientUtilityFactory) {
        if (this.clientUtilFactory == clientUtilityFactory) {
            this.clientUtilFactory = null;
        }
    }
}

