/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.api;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.adobe.granite.security.user.UserPropertiesService;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraph;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupUtil {
    private static final Logger log = LoggerFactory.getLogger(GroupUtil.class);

    public static boolean validateGroupName(ResourceResolver resolver, String name, String groupRoot) {
        if (name.startsWith("_")) {
            log.info("Group name {} begins with invalid charactor", (Object)name);
            return false;
        }
        PageManager pm = resolver.adaptTo(PageManager.class);
        Page childPage = pm.getPage(groupRoot + "/" + name);
        if (childPage != null) {
            log.info("Page {} already exists in {}", (Object)name, (Object)groupRoot);
            return false;
        }
        SocialGraph socialGraph = resolver.adaptTo(SocialGraph.class);
        GraphNode authorizable = socialGraph.getNode(name + "-admins");
        if (authorizable != null) {
            log.info("Authorizable {} already exists", (Object)(name + "-admins"));
            return false;
        }
        authorizable = socialGraph.getNode(name + "-members");
        if (authorizable != null) {
            log.info("Authorizable {} already exists", (Object)(name + "-members"));
            return false;
        }
        return true;
    }

    public static int getNumberOfMembers(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String groupId) {
        List<UserProperties> relations = GroupUtil.establishMemberRelation(userPropertiesService, resourceResolver, groupId);
        if (relations != null) {
            return relations.size();
        }
        return 0;
    }

    public static Iterator<UserProperties> getMembers(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String groupId) {
        List<UserProperties> relations = GroupUtil.establishMemberRelation(userPropertiesService, resourceResolver, groupId);
        if (relations != null) {
            return relations.iterator();
        }
        return null;
    }

    public static boolean isMember(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String authId, String groupId) {
        if (StringUtils.isEmpty((String)authId) || StringUtils.isEmpty((String)groupId)) {
            return false;
        }
        SocialGraph socialGraph = resourceResolver.adaptTo(SocialGraph.class);
        GraphNode group = socialGraph.getNode(groupId);
        GraphNode user = socialGraph.getNode(authId);
        if (group == null || user == null) {
            return false;
        }
        String relation = "member";
        Direction direction = Direction.INCOMING;
        return group.getRelationship(direction, user, "member") != null;
    }

    private static List<UserProperties> establishMemberRelation(UserPropertiesService userPropertiesService, ResourceResolver resourceResolver, String groupId) {
        ArrayList<UserProperties> results = new ArrayList<UserProperties>();
        if (StringUtils.isEmpty((String)groupId)) {
            return results;
        }
        try {
            UserPropertiesManager upm = userPropertiesService.createUserPropertiesManager(resourceResolver);
            SocialGraph socialGraph = resourceResolver.adaptTo(SocialGraph.class);
            GraphNode group = socialGraph.getNode(groupId);
            if (group == null) {
                return results;
            }
            String relation = "member";
            Direction direction = Direction.INCOMING;
            for (Relationship r : group.getRelationships(direction, "member")) {
                String authId = r.getOtherNode(group).getId();
                UserProperties memberProperties = upm.getUserProperties(authId, "profile");
                if (memberProperties == null || memberProperties.getNode().getPath().contains("groups")) continue;
                results.add(memberProperties);
            }
        }
        catch (RepositoryException e) {
            log.error("establishMemberRelation: error while establish relation for [{}]", (Object)groupId);
            log.error("", (Throwable)e);
        }
        return results;
    }

    public static String getCommunityRootPagePath(ResourceResolver resolver, String targetPath) {
        String parentPath = ResourceUtil.getParent(targetPath);
        Resource currentResource = resolver.getResource(targetPath);
        String communityRootPagePath = null;
        if (currentResource != null) {
            Resource parentPage = resolver.resolve(currentResource.getPath() + "/" + "jcr:content");
            if (parentPage != null && !ResourceUtil.isNonExistingResource(parentPage)) {
                Node parentNode = parentPage.adaptTo(Node.class);
                try {
                    if (parentNode.hasProperty("membergroup")) {
                        communityRootPagePath = currentResource.getPath();
                        return communityRootPagePath;
                    }
                    if (currentResource.getParent() == null) {
                        return communityRootPagePath;
                    }
                    communityRootPagePath = GroupUtil.getCommunityRootPagePath(resolver, parentPath);
                }
                catch (RepositoryException e) {
                    log.error("GroupUtil getParent() failed", (Throwable)e);
                }
            } else if (currentResource.getParent() != null) {
                communityRootPagePath = GroupUtil.getCommunityRootPagePath(resolver, parentPath);
            } else {
                return communityRootPagePath;
            }
        }
        return communityRootPagePath;
    }

    public static List<String> getAllMemberGroups(ResourceResolver resourceResolver, String userID) {
        SocialGraph socialGraph;
        GraphNode userNode;
        ArrayList<String> results = new ArrayList<String>();
        String author = userID;
        if (StringUtils.isEmpty((String)userID)) {
            author = resourceResolver.adaptTo(Session.class).getUserID();
        }
        if ((userNode = (socialGraph = resourceResolver.adaptTo(SocialGraph.class)).getNode(author)) == null) {
            return results;
        }
        String relation = "member";
        Direction direction = Direction.OUTGOING;
        for (Relationship r : userNode.getRelationships(direction, "member")) {
            String groupId = r.getOtherNode(userNode).getId();
            results.add(groupId);
        }
        return results;
    }

    public static List<String> getComponentsInMemberCommunities(ResourceResolver resourceResolver, String rootPath, String componentType, String userID) {
        ArrayList<String> results = new ArrayList<String>();
        List<String> memberGroups = GroupUtil.getAllMemberGroups(resourceResolver, userID);
        if (memberGroups.isEmpty()) {
            return results;
        }
        String queryString = "/jcr:root" + rootPath + "//element(*)[@sling:resourceType=\"" + componentType + "\"]";
        Iterator<Resource> children = resourceResolver.findResources(queryString, "xpath");
        while (children.hasNext()) {
            String path = children.next().getPath();
            String communitypath = GroupUtil.getCommunityRootPagePath(resourceResolver, path);
            Resource parentPage = resourceResolver.resolve(communitypath + "/" + "jcr:content");
            if (parentPage == null || ResourceUtil.isNonExistingResource(parentPage)) continue;
            Node parentNode = parentPage.adaptTo(Node.class);
            try {
                if (!parentNode.hasProperty("membergroup")) continue;
                String membergroup = parentNode.getProperty("membergroup").getString();
                if (membergroup != null && membergroup.indexOf("/") >= 0) {
                    membergroup = membergroup.substring(membergroup.lastIndexOf("/") + 1);
                }
                if (!memberGroups.contains(membergroup)) continue;
                results.add(path);
            }
            catch (RepositoryException e) {
                log.error("GroupUtil getComponentsInMemberCommunities() failed", (Throwable)e);
            }
        }
        return results;
    }
}

