/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.client.api;

import com.adobe.cq.social.commons.client.api.AbstractSocialComponentFactory;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.forum.client.impl.ForumImpl;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={SocialComponentFactory.class})
public class ForumSocialComponentFactory
extends AbstractSocialComponentFactory
implements SocialComponentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ForumSocialComponentFactory.class);
    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;

    @Override
    public String getSupportedResourceType() {
        return "social/forum/components/hbs/forum";
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        return new ForumImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.listProviderManager);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        return new ForumImpl(resource, this.getClientUtilities(request), this.getQueryRequestInfo(request), this.listProviderManager);
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo) {
        return new ForumImpl(resource, clientUtils, queryInfo, this.listProviderManager);
    }

    protected void bindListProviderManager(CommentSocialComponentListProviderManager commentSocialComponentListProviderManager) {
        this.listProviderManager = commentSocialComponentListProviderManager;
    }

    protected void unbindListProviderManager(CommentSocialComponentListProviderManager commentSocialComponentListProviderManager) {
        if (this.listProviderManager == commentSocialComponentListProviderManager) {
            this.listProviderManager = null;
        }
    }
}

