/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.api;

import com.adobe.cq.social.forum.api.Post;
import com.adobe.cq.social.ugc.api.RelatedSearch;
import com.adobe.cq.social.ugcbase.SocialResource;
import com.adobe.cq.social.ugcbase.SocialResourceProvider;
import com.adobe.cq.social.ugcbase.SocialResourceUtils;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, policy=ConfigurationPolicy.OPTIONAL, label="%relatedSearchUtil.name", description="%relatedSearchUtil.description")
public class RelatedSearchUtil {
    private static Logger log = LoggerFactory.getLogger(RelatedSearchUtil.class);
    @Reference
    private PageManagerFactory pageManagerFactory;
    @Reference
    private ConfigurationManager configManager;
    @Reference
    private RelatedSearch relatedSearch;
    @Reference
    private SocialUtils socialUtils;
    private static SocialUtils staticSocialUtils;
    private static RelatedSearch relatedSearchStatic;
    private static PageManagerFactory pageManagerFactoryStatic;
    private static ConfigurationManager configManagerStatic;

    protected final void activate(ComponentContext context) {
        relatedSearchStatic = this.relatedSearch;
        pageManagerFactoryStatic = this.pageManagerFactory;
        configManagerStatic = this.configManager;
        staticSocialUtils = this.socialUtils;
    }

    protected final void deactivate(ComponentContext context) {
        relatedSearchStatic = null;
        pageManagerFactoryStatic = null;
        configManagerStatic = null;
        staticSocialUtils = null;
    }

    public static List<Post> getRelatedPosts(ResourceResolver resolver, String query, String resourceTypeFilter, String componentFilter, String[] mltFields, int maxResults, int minTermFreq, int minDocFreq) throws RepositoryException {
        return RelatedSearchUtil.getRelatedPosts(resolver, query, null, resourceTypeFilter, componentFilter, mltFields, maxResults, minTermFreq, minDocFreq);
    }

    public static List<Post> getRelatedPosts(ResourceResolver resolver, String query, String statusFilter, String resourceTypeFilter, String componentFilter, String[] mltFields, int maxResults, int minTermFreq, int minDocFreq) throws RepositoryException {
        if (mltFields.length != 1) {
            log.error("Invalid mltFields sent. Exactly 1 field expected. Received: {}", (Object[])mltFields);
            return null;
        }
        LinkedList<Post> mltPosts = new LinkedList<Post>();
        Resource res = resolver.getResource(componentFilter);
        SocialResourceProvider srp = RelatedSearchUtil.getSocialResourceProvider(res);
        if (srp != null) {
            Iterator<Resource> mltIter = srp.getMLTResults(resolver, query, statusFilter, resourceTypeFilter, componentFilter, mltFields[0], maxResults, minTermFreq, minDocFreq);
            while (mltIter.hasNext()) {
                Resource postRes = mltIter.next();
                Post p = postRes.adaptTo(Post.class);
                if (p != null) {
                    mltPosts.add(p);
                    continue;
                }
                log.debug("Resource at path {} not a post", (Object)postRes.getPath());
            }
        } else {
            List<String> mltNodes = relatedSearchStatic.findMLT("ugc-related-search", query, resourceTypeFilter, componentFilter, mltFields, maxResults, minTermFreq, minDocFreq);
            if (mltNodes == null) {
                return null;
            }
            for (String node : mltNodes) {
                Resource postRes = resolver.getResource(node);
                if (postRes == null) continue;
                Post post = postRes.adaptTo(Post.class);
                mltPosts.add(post);
            }
        }
        return mltPosts;
    }

    private static SocialResourceProvider getSocialResourceProvider(Resource res) {
        log.debug("Getting cloud config");
        if (res == null) {
            log.debug("Resource is null have no starting point for getting the cloud service config.");
            return null;
        }
        Configuration config = staticSocialUtils.getStorageCloudServiceConfig(res);
        if (config != null) {
            String remoteLocation = config.get("asipath", null);
            if (remoteLocation != null) {
                SocialResource remoteResource = SocialResourceUtils.getSocialResource(res.getResourceResolver().getResource(remoteLocation));
                if (remoteResource != null) {
                    SocialResourceProvider resProvider = remoteResource.getResourceProvider();
                    if (resProvider != null) {
                        log.debug("Got SocialResourceProvider for resource at {}", (Object)remoteLocation);
                        return resProvider;
                    }
                    log.error("Unable to get a SocialResourceProvider for resource at {}", (Object)remoteLocation);
                } else {
                    log.debug("Remote resource is null or not a SocialResource");
                }
            } else {
                log.debug("Remote location is null");
            }
        } else {
            log.debug("Cloud config is null");
        }
        return null;
    }

    protected void bindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        this.pageManagerFactory = pageManagerFactory;
    }

    protected void unbindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        if (this.pageManagerFactory == pageManagerFactory) {
            this.pageManagerFactory = null;
        }
    }

    protected void bindConfigManager(ConfigurationManager configurationManager) {
        this.configManager = configurationManager;
    }

    protected void unbindConfigManager(ConfigurationManager configurationManager) {
        if (this.configManager == configurationManager) {
            this.configManager = null;
        }
    }

    protected void bindRelatedSearch(RelatedSearch relatedSearch) {
        this.relatedSearch = relatedSearch;
    }

    protected void unbindRelatedSearch(RelatedSearch relatedSearch) {
        if (this.relatedSearch == relatedSearch) {
            this.relatedSearch = null;
        }
    }

    protected void bindSocialUtils(SocialUtils socialUtils) {
        this.socialUtils = socialUtils;
    }

    protected void unbindSocialUtils(SocialUtils socialUtils) {
        if (this.socialUtils == socialUtils) {
            this.socialUtils = null;
        }
    }
}

