/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.api;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.forum.api.Forum;
import com.adobe.cq.social.forum.api.ForumUser;
import com.adobe.cq.social.forum.api.Post;
import com.adobe.cq.social.forum.impl.ForumUserImpl;
import com.day.cq.security.Authorizable;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class ForumUtil {
    public static Forum getForum(Page page) {
        return ForumUtil.findForumResource(page.getContentResource());
    }

    private static Forum findForumResource(Resource resource) {
        Iterator<Resource> it = resource.listChildren();
        Forum forum = null;
        while (null == forum && it.hasNext()) {
            Resource r = it.next();
            if (ForumUtil.isForum(r)) {
                forum = r.adaptTo(Forum.class);
                continue;
            }
            forum = ForumUtil.findForumResource(r);
        }
        return forum;
    }

    public static boolean isForum(Resource resource) {
        return null != resource && ResourceUtil.isA(resource, "social/forum/components/forum");
    }

    public static boolean mayPost(ResourceResolver resolver, Forum forum) {
        if (null != resolver && null != forum) {
            if ("anonymous".equals(resolver.adaptTo(Session.class).getUserID())) {
                return false;
            }
            Resource r = resolver.getResource(forum.getPath());
            if (null != r) {
                r = resolver.getResource(CollabUtil.resourceToUGCPath(r));
            }
            if (null == r) {
                PageManager pm = resolver.adaptTo(PageManager.class);
                Page page = pm.getContainingPage(resolver.getResource(forum.getPath()));
                StringBuilder ugcPagePath = new StringBuilder("/content/usergenerated");
                ugcPagePath.append(page.getPath());
                r = resolver.getResource(ugcPagePath.toString());
                if (r == null) {
                    r = resolver.getResource("/content/usergenerated");
                }
            }
            return CollabUtil.canAddNode(resolver.adaptTo(Session.class), r.getPath());
        }
        return false;
    }

    @Deprecated
    public static boolean mayEdit(ResourceResolver resolver, Authorizable authorizable, Post post) throws RepositoryException {
        if (ForumUtil.mayPost(resolver, post.getForum())) {
            if (post.getCreatedBy().getUserID().equals(authorizable.getID())) {
                return true;
            }
            return ForumUtil.mayEditWithACL(resolver, post.getPath(), authorizable.getPrincipal());
        }
        return false;
    }

    private static boolean mayEditWithACL(ResourceResolver resolver, String path, Principal princ) throws RepositoryException {
        if (princ == null) {
            return false;
        }
        Session session = resolver.adaptTo(Session.class);
        AccessControlManager acMgr = session.getAccessControlManager();
        LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
        principals.add(princ);
        PrincipalIterator it = ((JackrabbitSession)session).getPrincipalManager().getGroupMembership(princ);
        while (it.hasNext()) {
            principals.add(it.nextPrincipal());
        }
        List<Privilege> privs = Arrays.asList(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"));
        return ((JackrabbitAccessControlManager)acMgr).hasPrivileges(path, principals, privs.toArray(new Privilege[privs.size()]));
    }

    public static void redirectToPage(Forum forum, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String postId = request.getParameter("redirectToPost");
        if (StringUtils.isNotBlank((String)postId)) {
            int pageIndex;
            int currentIndex;
            Post post;
            Post topic = forum.getPostFromRequest(request);
            Post post2 = post = null != topic ? topic.getPost(postId) : null;
            if (null != post && (currentIndex = forum.getRequestPageNumber(request)) != (pageIndex = post.getPageIndex())) {
                response.sendRedirect(post.getUrl());
            }
        }
    }

    public static ForumUser createForumUser(String userId, ResourceResolver resolver) {
        return new ForumUserImpl(userId, resolver);
    }

    public static boolean isHBS(Resource resource) {
        return null != resource && (resource.isResourceType("social/forum/components/hbs/forum") || resource.isResourceType("social/forum/components/hbs/post"));
    }
}

